
** Global Multidimensional Poverty Index - Mexico ENSANUT 2022 ** 

clear all 
set more off
set maxvar 10000

global path_in "../rdta/Mexico ENSANUT 2022"     // folder path
global path_out "cdta"
global path_ado "ado"



/* The microdata may be downloaded from:
	https://ensanut.insp.mx/index.php  */


**# step 1: data cleaning


**## child under 5

use "$path_in/ensaantro2022_entrega_w.dta", clear

rename _all, lower


duplicates report folio_int 					//  qc: no duplicates

sort folio_int


count if fech_nac>="99000000"

gen sbdy=substr(fech_nac, 1, 2)
gen sbmt=substr(fech_nac, 3, 2)
gen sbyr=substr(fech_nac, 5, 4)


foreach i in dy mt yr {										 
	 	
	destring sb`i', gen(b`i')
	codebook b`i', ta(9999)
}

					// imputing missing birth day
count if bdy>31 & bmt<=12 & byr<9999

replace bdy = 15 if bdy>31 & bmt<=12 & byr<9999


					// imputing missing birth month
count if bdy<=31 & bmt>12 & byr<9999

replace bmt = 6 if bdy<=31 & bmt>12 & byr<9999

 
 
gen bdt = mdy(bmt, bdy, byr) 			    	 // birth date
replace bdt = . if byr>=9999
format bdt %td


gen idt = date(fecha_fin, "DMY") 				// interview date
format idt %td


gen age = (idt-bdt)/30.4375 					// qc: age in mth
replace age = h0303*12 if (age<0 | age==.)
su age 											// qc: check min & max 

gen str6 ageunit = "months"
lab var ageunit "months"
		

		
ta h0303 if age<61, m			 // qc: within the 5 year age group

keep if age<61					// keep only elg ch



gen chelg = 1
lab var chelg "child eligible for measurement" 
count												// qc: 1,826 children



codebook h0302							 // qc: sex: 1=male; 2=female 

clonevar gender = h0302



desc an01_*								// qc: body weight in kg

codebook an01_1, ta(999)

codebook an01_1, ta(999)
					

egen weight = rowmean(an01_1 an01_2) if an01_1<200 & an01_2<200

ta an03 if an01_1>=200 & an01_2>200, m	  // qc: why missing

su weight



desc an04_*							  // qc: height in cm

codebook an04_1, ta(999) 

codebook an04_1, ta(999) 					

egen height = rowmean (an04_1 an04_2) if an04_1<200 & an04_2<200	

ta an05 if an04_1>200 & an04_2>200, m	  // qc: why missing

su height



gen measure = "l" if age<24   	 			// u24 mth measured lying down
replace measure = "h" if age>=24 & age!=.   // 24+ mth measured standing up
ta measure	


gen oedema = "n" 										// oedema


gen sw = 1												// sampling weight


gen chswgt = ponde_f
lab var chswgt "sample weight child u5" 


adopath + "$path_ado/igrowup_stata"		 	 			// compute z-score
gen str100 reflib = "$path_ado/igrowup_stata"
lab var reflib "Directory of reference tables"
gen str100 datalib = "$path_out" 
lab var datalib "Directory for datafiles"
gen str30 datalab = "ch_mex" 
lab var datalab "Working file"


igrowup_restricted reflib datalib datalab gender age 	///
ageunit weight height measure oedema sw


use "$path_out/ch_mex_z_rc.dta", clear 


foreach m of newlist wei len wfl {

	gen	`m'_a = (_z`m' < -2.0)    									// a = mpi
	replace `m'_a = . if _z`m' == . | _f`m'==1

	gen	`m'_u = (_z`m' < -3.0) 										// u = dst
	replace `m'_u = . if _z`m' == . | _f`m'==1
		
}


rename (wei_a len_a wfl_a) (underweight_a stunted_a wasted_a)
rename (wei_u len_u wfl_u) (underweight_u stunted_u wasted_u)


foreach i in underweight stunted wasted {	
	lab var `i'_a  "mpi: child is `i'"
	lab var `i'_u  "dst: child is `i'"
	
	ta `i'_a [aw=chswgt],m       // qc: % underweight; stunted 
	ta `i'_u [aw=chswgt],m 
}



foreach v in a u {								

gen uw_st_`v' = 1 if stunted_`v'==1 | underweight_`v'==1		
replace uw_st_`v' = 0 if stunted_`v'==0 & underweight_`v'==0
replace uw_st_`v' = . if stunted_`v'==. & underweight_`v'==.

}

lab var uw_st_a "mpi: child is uwgt/stunted"   			
lab var uw_st_u "dst: child is uwgt/stunted"  			



count if _fwei==1 | _flen==1  				// biologically implausible zscore 
	
 
keep folio_i folio_int chelg chswgt underweight* stunted* wasted* uw_st* 
order folio_i folio_int chelg chswgt underweight* stunted* wasted* uw_st* 
sort folio_int
save "$path_out/MEX22_CH.dta", replace


	 	
erase "$path_out/ch_mex_z_rc.xls" 				// erase files
erase "$path_out/ch_mex_prev_rc.xls"
erase "$path_out/ch_mex_z_rc.dta"

		

**## household recode

use "$path_in/hogar_ensanut2022_w.dta", clear
	
	
rename _all, lower	


duplicates report folio_i		


save "$path_out/MEX22_HR.dta", replace

		
		
**## hh members

use "$path_in/integrantes_ensanut2022_w.dta", clear


rename _all, lower	


encode folio_i, gen(hh_id)
format hh_id %20.0g
lab var hh_id "household id"


encode folio_int, gen(ind_id)
format ind_id %20.0g
lab var ind_id "individual id"


sort hh_id ind_id
duplicates report ind_id 			// qc: 36,483 ind  


		
**## data merging 

merge m:1 folio_i using "$path_out/MEX22_HR.dta"  			  // hh recode
drop _merge
erase "$path_out/MEX22_HR.dta"


merge 1:1 folio_i folio_int using "$path_out/MEX22_CH.dta"   // nutr ch
drop _merge
erase "$path_out/MEX22_CH.dta"


count 

bys hh_id: gen id = _n
count if id==1			// qc: 10,465 hh interviewed



**## eligibility variable

												// nutr
desc h0304d h0304m h0304a
												
codebook h0304d h0304m h0304a, ta(999)				

gen bd = h0304d if h0304d<99
gen bm = h0304m if h0304m<99
gen by = h0304a if h0304a<9999

	
gen bdt = mdy(bm, bd, by)							// birth date
replace bdt = mdy(bm, 15 , by) if h0304d>31
su bdt


gen mdt = date(fecha_fin, "DMY") 					// interview date
format mdt %td
su mdt


gen age_m = (mdt-bdt)/30.4375 						// age in months
replace age_m = h0303*12 if age_m==. & h0303<999
lab var age_m "age in months"
su age_m


gen ch_elg = (age_m<61)
bys	hh_id: egen no_ch_elg = min(ch_elg==0) 
lab var no_ch_elg "hh has no elg child for nutr"
ta no_ch_elg, m



**## relevant variables

desc ponde_f upm estrato


clonevar weight = ponde_f							  // sample weight 
lab var weight "sample weight"


encode upm, gen (psu)								  // sample design
lab var psu "primary sampling unit"


clonevar strata = estrato  	
lab var strata "sample strata"

svyset psu [pw=weight] , strata(strata)	 singleunit(centered)



codebook estrato 									// urban-rural

recode estrato (1= 0 "rural") (2 3 = 1 "urban"), gen (area)
lab var area "area"
ta estrato area, m



codebook h0305 						  			 // relationship

recode h0305 (1=1 "head")(2=2 "spouse")(3=3 "child") ///
(4/8=4 "extended family")(9=5 "not related"), gen (rship)
lab var rship "relationship"
ta h0305 rship, m	



codebook h0302  								 // sex

recode h0302 (1=1 "male") (2=2 "female"), gen(sex)
lab var sex "sex"



bys	hh_id: egen xhhead = min(rship) 			// headship
ta xhhead,m

gen hhead = (rship==1 & sex==1) | (xhhead==2 & rship==2 & sex==1)  
replace hhead = 2 if (rship==1 & sex==2) | (xhhead==2 & rship==2 & sex==2)

bys hh_id: egen hship = sum(hhead)

replace hship = . if xhhead > 2 | hship==0  	// hh, no head
lab def la_hs 1"male-headed" 2"female-headed"
lab val hship la_hs
lab var hship "gender of hh head"
ta hship, m



codebook h0303, ta (999)						// age; age group

gen age = h0303 if h0303<900
lab var age "age"


recode age (0/4 = 1 "0-4")(5/9 = 2 "5-9")(10/14 = 3 "10-14") ///
		   (15/17 = 4 "15-17")(18/59 = 5 "18-59")(60/max=6 "60+"), gen(agec7)
lab var agec7 "age groups (7 groups)"	
	   
recode age (0/9 = 1 "0-9") (10/17 = 2 "10-17")(18/59 = 3 "18-59") ///
		   (60/max=4 "60+"), gen(agec4)
lab var agec4 "age groups (4 groups)"

recode age (0/17 = 1 "0-17") (18/max = 2 "18+"), gen(agec2)		 		   
lab var agec2 "age groups (2 groups)"



codebook h0319, ta (9) 						// marital status

recode h0319 (7=1 "never married") ///
(1 6 = 2 "currently married") (5=3 "widowed") ///
(4=4 "divorced") (2 3 = 5 "not living together"), gen (marital)	
lab var marital "marital status"
ta h0319 marital, m


gen member = 1 								// hh size
bys hh_id: egen hhsize = sum(member)
lab var hhsize "household size"
ta hhsize, m



codebook region, ta (99)				// region
					

recode region (5=1 "Centro") (4=2 "Centro-Norte") /// 
(2=3 "Frontera") (6=4 "México City") /// 
(3=5 "Pacifico-Centro") (1=6 "Pacifico-Norte") /// 
(7=7 "Pacífico-Sur") (8=8 "Península"), gen(region_n)

ta region region_n,m

drop region
rename region_n region
lab var region "subnational region"



							// subnational region, harmonised over time
							
recode region (2 3 6=1 "Norte") (5=2 "Centro") ///
(4=3 "México City") (1 7 8=4 "Sur"), gen (region_01)

lab var region_01 "hot: subnational region"
	


**# step 2: indicator construction


**## school attendance

codebook h0313, ta (99)

recode h0313 (1=1 "in sch") (2=0 "out of sch"), gen (att)
lab var att "sch att status"	
ta att, m 										// qc: missing replaced as '.'

	
gen	scheg_a = (age>=6 & age<=14)   				// qc: mpi - age range of elg
lab var scheg_a "mpi: elg for school att"


gen	scheg_u = (age>=6 & age<=12)    			// qc: dst - age range of elg
lab var scheg_u "dst: elg for school att"	


								// policy: >=2/3 elg pop have non-missing data 
								
foreach v in a u {										// a=mpi; u=dst	 
	 	
	gen tmp_`v' = 1 if scheg_`v'==1 & att!=. 		
	bys hh_id: egen hsattdt_`v' = sum(tmp_`v')	 	// elg & no missing data
	drop tmp_`v'
	
	bys hh_id: egen hscheg_`v' = sum(scheg_`v')  		// elg population

	replace hsattdt_`v' = hsattdt_`v'/hscheg_`v' 
	replace hsattdt_`v' = (hsattdt_`v'>=2/3)	 		
	ta hsattdt_`v', m							     	// qc: missing < 0.5% 	
}



foreach i in a u {							// school att indc (a=mpi; u=dst)

	gen tmp_`i' = (att==1) if scheg_`i'==1 & att!=.     		
	bys	hh_id: egen satt_`i' = min(tmp_`i') 
	replace satt_`i' = . if hsattdt_`i'==0	& satt_`i'==1			// policy
	replace satt_`i' = 1 if hscheg_`i'==0  						   // non-elg 
	drop tmp_`i'

	ta satt_`i', m
							
}

lab var satt_a "mpi: not deprived in satt"					
lab var satt_u "dst: not deprived in satt"



**## years of schooling

codebook h0317a h0317g, ta(99)

ta h0317g h0317a,m

gen eduyr = h0317g if h0317a==2 | h0317a==5 

replace eduyr = 0 if h0317a<=1
replace eduyr = h0317g + 6 if h0317a==3 | h0317a==6
replace eduyr = h0317g + 9 if h0317a==4 | h0317a==7
replace eduyr = h0317g + 12 if h0317a>=8 & h0317a<=10
replace eduyr = h0317g + 15 if h0317a==11 | h0317a==12

lab var eduyr "total years of schooling"     
 

replace eduyr = . if age<=eduyr & age>0 	 	// missing if eduyr >= age

ta eduyr, m



	/* note: all those who should have completed 6 years 
	of schooling from their starting sch age are counted 
	as eligible, as well as early starters (from age of 10)
	who uniqely have up to six years of schooling are eligible. */
	

											// formal sch age is from 6 years
gen edueg = (age>=12 & age!=.) | ((age==10 | age==11) & ///
			(eduyr>=6 & eduyr!=.)) | (age==. & eduyr>=6 & eduyr!=.)	
							 
lab var edueg "elg for years of schooling"
ta edueg,m



								// policy: >=2/3 elg pop have non-missing data 	
gen tmp = 1 if eduyr!=. & edueg==1
bys	hh_id: egen hedudt = sum(tmp)				// elg pop with no missing data
drop tmp				
	
bys hh_id: egen hedueg = sum(edueg==1) 			// elg population

replace hedudt = hedudt/hedueg
replace hedudt = (hedudt>=2/3)		
ta hedudt, m									// qc: missing < 0.5% 	
lab var hedudt "non-missing edu" 
							
									
									// mpi: completed six years of schooling
gen	tmp_a = (eduyr>=6 & eduyr!=. & edueg==1)   	
replace tmp_a = . if eduyr==. & edueg==1

									// dst: completed one year of schooling
gen	tmp_u = (eduyr>=1 & eduyr!=. & edueg==1)		
replace tmp_u = . if eduyr==. & edueg==1								
								
								
foreach i in a u {							
	bys hh_id: egen educ_`i' = max(tmp_`i')
	replace educ_`i' = . if educ_`i'==0 & hedudt==0 				// policy
	drop tmp_`i'
	
	ta educ_`i', m							
}
																
lab var educ_a "mpi: not deprived in yos"
lab var educ_u "dst: not deprived in yos"



**## nutrition

foreach msr in uw_st_a uw_st_u {	

	bys hh_id: egen tmp = max(`msr')
	gen	no_`msr' = (tmp==0)	if tmp!=.			
	drop tmp
	replace no_`msr' = 1 if no_ch_elg==1			// hh no elg child 

	ta no_`msr',m 
}

lab var no_uw_st_a "mpi: no underweight/stunted child in hh"
lab var no_uw_st_u "dst: no underweight/stunted child in hh"	


foreach i in a u {							 // nutr indc (a = mpi; u = dst)

gen	nutr1_`i' = 1  														
replace nutr1_`i' = 0 if no_uw_st_`i'==0
replace nutr1_`i' = . if no_uw_st_`i'==.
replace nutr1_`i' = 1 if no_ch_elg==1   	


ta nutr1_`i', m

}

lab var nutr1_a "mpi: not deprived in nutr (u5)"
lab var nutr1_u "dst: not deprived in nutr (u5)"



**## child mortality

gen cm9 = .
lab var cm9 "no child mortality data"

	

**## electricity 

codebook h0111, ta (9)

recode h0111 (2=0 "no") (1=1 "yes"), gen (elct)			// mpi = dst
lab var elct "not deprived in elct"

ta h0111 elct,m
								


**## sanitation

desc h0119 h0118 h0120

codebook h0119 h0118, ta(9)


ta h0119 h0118,m

gen	sani_a = (h0119<=2 & h0118<=2) 						// mpi

replace sani_a = . if h0119==. & h0118==.


codebook h0120

replace sani_a = 0 if h0120==1				
lab var sani_a "mpi: not deprived in sani"


svy: prop sani_a 								



recode h0119 (1 2 3 = 1 "yes") ///
(4 = 0 "no"), gen(sani_u)   						  // dst

lab var sani_u "dst: not deprived in sani"

ta h0119 sani_u, m



**## drinking water 

codebook h0114 h0112, ta(99)

ta h0114 h0112,m

recode h0114 (2 3 4 6 = 1 "yes") ///
(1 5 = 0 "no"), gen(wtr7)						  // mpi

replace wtr7=1 if h0112<=2

lab var wtr7 "not deprived in dwtr (no time data)"

ta h0114 wtr7, m								



**## housing

desc h0103 h0102 h0101


codebook h0103, ta (99)			// improved = rudimentary & finished floor
 
recode h0103 (2 3 = 1 "yes") (1 = 0 "no"), gen(floor)
lab var floor "hh has improved floor"
ta h0103 floor,m


codebook h0102, ta (99)					// improved = finished walls 

recode h0102 (6/8 = 1 "yes") (1/5 = 0 "no"), gen(wall)
lab var wall "hh has improved wall"
ta h0102 wall,m


codebook h0101, ta (99)					// improved = finished roofing 

recode h0101 (6/9 = 1 "yes") (1/5 = 0 "no"), gen(roof)
lab var roof "hh has improved roof"
ta h0101 roof,m	



gen hsg_a = 1  														// mpi
replace hsg_a = 0 if floor==0 | wall==0 | roof==0
replace hsg_a = . if floor==. & wall==. & roof==.
lab var hsg_a "mpi: not deprived in hsg"
ta hsg_a, m



gen hsg_u = 1 														// dst
replace hsg_u = 0 if ///
(floor==0 & wall==0 & roof==1) | ///
(floor==0 & wall==1 & roof==0) | ///
(floor==1 & wall==0 & roof==0) | ///
(floor==0 & wall==0 & roof==0)

replace hsg_u = . if floor==. & wall==. & roof==.
lab var hsg_u "dst: not deprived in hsg"
ta hsg_u, m



**## cooking fuel
	
codebook h0109 h0110 h0107, ta (99)

ta h0109 h0110, m					
ta h0109 h0107, m		// qc: missing in h0109 because h0107=not cooking 


gen ckfl = 1													// mpi	 
replace ckfl = 0 if h0109==1 | h0109==2
replace ckfl = . if h0109==. & h0107==.

lab var ckfl "not deprived in ckfl"	

ta h0109 h0110 if ckfl==1 & h0107!=. ,m 
								


**## assets

lookfor automóvil camioneta
ta h0501v h0501w, m nol

gen car = (h0501v==1 | h0501w==1) 
replace car = . if h0501v ==. & h0501w==.
lab var car "hh has car"	
ta h0501v h0501w if car==1,m




lookfor téléphone ipod telefone tele celular 
codebook h0501f
clonevar phone = h0501f
lab var phone "hh has telephone"			


lookfor radio walkman stereo stéréo
codebook h0501c
clonevar radio = h0501c
lab var radio "hh has radio"


lookfor tv television plasma lcd télé tele
codebook h0501a
clonevar tv = h0501a 
lab var tv "hh has television"


lookfor refrigerator réfrigérateur refri freezer
codebook h0501k 
clonevar fridge = h0501k 
lab var fridge "hh has refrigerator"


lookfor motorbike moto motocicleta
codebook h0501x 	
clonevar mbike = h0501x 
lab var mbike "hh has motorbike"


lookfor computadora  ordinateur laptop ipad tablet 
codebook h0501e
clonevar comp = h0501e
lab var comp "hh has computer"



lab def la_at 0"no" 1"yes" 
foreach var in car phone radio tv fridge mbike comp {
replace `var' = 0 if `var'==2 
lab val `var' la_at			   
replace `var' = . if `var'==9 | `var'==99 | `var'==8 | `var'==98 
}


egen n_bast5 = rowtotal (phone radio tv fridge mbike comp), m
lab var n_bast5 "basic assets owned by hh (excl bike & acart)" 
 
 
gen asst5_a = (car==1 | n_bast5 > 1)   							// mpi
replace asst5_a = . if car==. & n_bast5==.
lab var asst5_a "mpi: not deprived in assets (excl bike & acart)"



gen	asst5_u = (car==1 | n_bast5 > 0)  						 // dst
replace asst5_u = . if car==. & n_bast5==.
lab var asst5_u "dst: not deprived in assets (excl bike & acart)"



**# step 3: spec & flav

recode cm9   	(0=1)(1=0) , gen(d_cm)						// MPI est 
recode nutr1_a 	(0=1)(1=0) , gen(d_nutr)
recode satt_a 	(0=1)(1=0) , gen(d_satt)
recode educ_a 	(0=1)(1=0) , gen(d_educ)
recode elct		(0=1)(1=0) , gen(d_elct)
recode wtr7 	(0=1)(1=0) , gen(d_wtr)
recode sani_a	(0=1)(1=0) , gen(d_sani)
recode hsg_a 	(0=1)(1=0) , gen(d_hsg)
recode ckfl 	(0=1)(1=0) , gen(d_ckfl)
recode asst5_a 	(0=1)(1=0) , gen(d_asst)


recode cm9   	(0=1)(1=0) , gen(d_cm_01)	 			    // hot MPI est 
recode nutr1_a 	(0=1)(1=0) , gen(d_nutr_01)
recode satt_a 	(0=1)(1=0) , gen(d_satt_01)
recode educ_a 	(0=1)(1=0) , gen(d_educ_01)
recode elct		(0=1)(1=0) , gen(d_elct_01)
recode wtr7 	(0=1)(1=0) , gen(d_wtr_01)
recode sani_a	(0=1)(1=0) , gen(d_sani_01)
recode hsg_a 	(0=1)(1=0) , gen(d_hsg_01)
recode ckfl 	(0=1)(1=0) , gen(d_ckfl_01)
recode asst5_a 	(0=1)(1=0) , gen(d_asst_01)



recode cm9   	(0=1)(1=0) , gen(dst_cm)					// dst est
recode nutr1_u 	(0=1)(1=0) , gen(dst_nutr)
recode satt_u 	(0=1)(1=0) , gen(dst_satt)
recode educ_u 	(0=1)(1=0) , gen(dst_educ)
recode elct 	(0=1)(1=0) , gen(dst_elct)
recode wtr7  	(0=1)(1=0) , gen(dst_wtr)
recode sani_u 	(0=1)(1=0) , gen(dst_sani)
recode hsg_u  	(0=1)(1=0) , gen(dst_hsg)
recode ckfl 	(0=1)(1=0) , gen(dst_ckfl)
recode asst5_u 	(0=1)(1=0) , gen(dst_asst) 


recode cm9   	(0=1)(1=0) , gen(dst_cm_01)				    // hot dst est
recode nutr1_u	(0=1)(1=0) , gen(dst_nutr_01)
recode satt_u 	(0=1)(1=0) , gen(dst_satt_01)
recode educ_u 	(0=1)(1=0) , gen(dst_educ_01)
recode elct 	(0=1)(1=0) , gen(dst_elct_01)
recode wtr7  	(0=1)(1=0) , gen(dst_wtr_01)
recode sani_u 	(0=1)(1=0) , gen(dst_sani_01)
recode hsg_u  	(0=1)(1=0) , gen(dst_hsg_01)
recode ckfl 	(0=1)(1=0) , gen(dst_ckfl_01)
recode asst5_u 	(0=1)(1=0) , gen(dst_asst_01) 



lab def la_dp 1"yes" 0"no"
foreach var in d_* dst_* d_*_* dst_*_* {
lab val `var' la_dp
}

foreach var in cm nutr satt educ elct wtr sani hsg ckfl asst {
lab var d_`var' "deprived in `var'"
lab var d_`var'_01 "hot: deprived in `var'"
lab var dst_`var' "dst: deprived in `var'"
lab var dst_`var'_01 "hot-dst: deprived in `var'"
}


keep hh_id ind_id strata psu weight chswgt ///
sex age agec* area region* hship  ///
scheg_a att edueg eduyr ///
chelg underweight_a stunted_a uw_st_a ///
d_* dst_*  

	 
order hh_id ind_id strata psu weight chswgt ///
sex age agec* area region* hship  ///
scheg_a att edueg eduyr ///
chelg underweight_a stunted_a uw_st_a ///
d_* dst_* 


mdesc psu strata area age hship region* d_* dst_*


char _dta[cty] "Mexico"
char _dta[ccty] "MEX"
char _dta[year] "2022" 	
char _dta[survey] "ENSANUT"
char _dta[ccnum] "484"
char _dta[type] "micro"


sort ind_id
compress
la da "Micro data for `_dta[ccty]' (`_dta[ccnum]') from `c(current_date)' (`c(current_time)')."
save "$path_out/mex_ensanut22.dta", replace 