
** Global Multidimensional Poverty Index - Mexico ENSANUT 2016 ** 

clear all 
set more off
set maxvar 10000

global path_in "../rdta/Mexico ENSANUT 2016"     // folder path
global path_out "cdta"
global path_ado "ado"



/* The microdata may be downloaded from:
	https://ensanut.insp.mx/index.php  */


**# step 1: data cleaning


**## child under 5

use "$path_in/ponde_antropo_2_PROCESADA_09112016.dta", clear 

gen hh_id = folio
gen ind_id = int

duplicates report hh_id ind_id				// qc: no duplicates


codebook edad meses, ta(999)
gen age = (edad*12) + meses 
su age

gen str6 ageunit = "months" 
lab var ageunit "months"	

		
keep if age<61					// keep only elg ch


gen chelg = 1
lab var chelg "child eligible for measurement" 
count												// qc: 2,083 children



codebook sexo							 // qc: sex: 1=male; 2=female 

recode sexo (1=1 "male")(2=2 "female"), gen(gender)


desc peso*								// qc: body weight in kg

codebook peso, ta(999)

codebook peso2, ta(999)
					

egen weight = rowmean(peso peso2) if peso<200 & peso2<200

ta rpeso if peso>=200 & peso2>200, m	  // qc: why missing

su weight



desc talla*							  // qc: height in cm

codebook talla, ta(999) 

codebook talla2, ta(999) 					

egen height = rowmean (talla talla2) if talla<200 & talla2<200	

ta rpeso if talla>200 & talla2>200, m	  // qc: why missing

su height



gen measure = "l" if age<24   	 			// u24 mth measured lying down
replace measure = "h" if age>=24 & age!=.   // 24+ mth measured standing up
ta measure	


gen oedema = "n" 										// oedema


gen sw = 1												// sampling weight


gen chswgt = ponde_f
lab var chswgt "sample weight child u5" 


adopath + "$path_ado/igrowup_stata"		 	 			// compute z-score
gen str100 reflib = "$path_ado/igrowup_stata"
lab var reflib "Directory of reference tables"
gen str100 datalib = "$path_out" 
lab var datalib "Directory for datafiles"
gen str30 datalab = "ch_mex" 
lab var datalab "Working file"


igrowup_restricted reflib datalib datalab gender age 	///
ageunit weight height measure oedema sw


use "$path_out/ch_mex_z_rc.dta", clear 


foreach m of newlist wei len wfl {

	gen	`m'_a = (_z`m' < -2.0)    									// a = mpi
	replace `m'_a = . if _z`m' == . | _f`m'==1

	gen	`m'_u = (_z`m' < -3.0) 										// u = dst
	replace `m'_u = . if _z`m' == . | _f`m'==1
		
}


rename (wei_a len_a wfl_a) (underweight_a stunted_a wasted_a)
rename (wei_u len_u wfl_u) (underweight_u stunted_u wasted_u)


foreach i in underweight stunted wasted {	
	lab var `i'_a  "mpi: child is `i'"
	lab var `i'_u  "dst: child is `i'"
	
	ta `i'_a [aw=chswgt],m       // qc: % underweight; stunted 
	ta `i'_u [aw=chswgt],m 
}



foreach v in a u {								

gen uw_st_`v' = 1 if stunted_`v'==1 | underweight_`v'==1		
replace uw_st_`v' = 0 if stunted_`v'==0 & underweight_`v'==0
replace uw_st_`v' = . if stunted_`v'==. & underweight_`v'==.

}

lab var uw_st_a "mpi: child is uwgt/stunted"   			
lab var uw_st_u "dst: child is uwgt/stunted"  			



count if _fwei==1 | _flen==1  				// biologically implausible zscore 
	
 
keep hh_id ind_id chelg chswgt underweight* stunted* wasted* uw_st* 
order hh_id ind_id chelg chswgt underweight* stunted* wasted* uw_st* 
sort hh_id ind_id
save "$path_out/MEX16_CH.dta", replace


	 	
erase "$path_out/ch_mex_z_rc.xls" 				// erase files
erase "$path_out/ch_mex_prev_rc.xls"
erase "$path_out/ch_mex_z_rc.dta"

		

**## household recode

use "$path_in/Hogar_socioeconomicoprocesada.dta", clear
	
	
gen hh_id = folio
gen ind_id = int


sort hh_id ind_id
duplicates report hh_id ind_id			// 9,479 hh


save "$path_out/MEX16_HR.dta", replace

		
		
**## hh members

use "$path_in/Hogar_Integrantes_procesada.dta", clear
 
 
gen hh_id = folio
lab var  hh_id "household id"


gen ind_id = int
label var ind_id "individual id"


desc hh_id ind_id
duplicates report hh_id ind_id				// 27,795 ind 


		
**## data merging 

merge m:1 hh_id using "$path_out/MEX16_HR.dta"  			 // hh recode
drop _merge
erase "$path_out/MEX16_HR.dta"


merge 1:1 hh_id ind_id using "$path_out/MEX16_CH.dta" 		// nutr ch 
drop _merge
erase "$path_out/MEX16_CH.dta"


count 


bys hh_id: gen id = _n
count if id==1					// qc: 9,479 hh interviewed



**## eligibility variable

gen age_m = (edad*12) + meses  						// age in mths
replace age_m = . if edad==999
lab var age_m "age in months"
su age_m


gen ch_elg = (age_m<61)
bys	hh_id: egen no_ch_elg = min(ch_elg==0) 
lab var no_ch_elg "hh has no elg child for nutr"
ta no_ch_elg, m


count if ch_elg==1
count if chelg==1  			// from nutr data file



**## relevant variables

desc ponde_h code_upm est_var


clonevar weight = ponde_h					 // sample weight 
lab var weight "sample weight"


encode code_upm, gen (psu)					// sample design
lab var psu "primary sampling unit"


clonevar strata = est_var  	
lab var strata "sample strata"

svyset psu [pw=weight] , strata(strata)	 singleunit(centered)



codebook estrato 							// urban-rural

recode estrato (1= 0 "rural") (2 3 = 1 "urban"), gen (area)
lab var area "area"
ta estrato area, m



codebook h207 						  	// relationship

recode h207 (1=1 "head")(2=2 "spouse")(3=3 "child") ///
(4/77=4 "extended family")(9=5 "not related"), gen (rship)
lab var rship "relationship"
ta h207 rship, m	



codebook sexo	  								 // sex

recode sexo (1=1 "male") (2=2 "female"), gen(sex)
lab var sex "sex"



bys	hh_id: egen xhhead = min(rship) 			// headship
ta xhhead,m

gen hhead = (rship==1 & sex==1) | (xhhead==2 & rship==2 & sex==1)  
replace hhead = 2 if (rship==1 & sex==2) | (xhhead==2 & rship==2 & sex==2)

bys hh_id: egen hship = sum(hhead)

replace hship = . if xhhead > 2 | hship==0  	// hh, no head
lab def la_hs 1"male-headed" 2"female-headed"
lab val hship la_hs
lab var hship "gender of hh head"
ta hship, m



codebook edad, ta (999)						// age; age group

gen age = edad if edad<900
lab var age "age"


recode age (0/4 = 1 "0-4")(5/9 = 2 "5-9")(10/14 = 3 "10-14") ///
		   (15/17 = 4 "15-17")(18/59 = 5 "18-59")(60/max=6 "60+"), gen(agec7)
lab var agec7 "age groups (7 groups)"	
	   
recode age (0/9 = 1 "0-9") (10/17 = 2 "10-17")(18/59 = 3 "18-59") ///
		   (60/max=4 "60+"), gen(agec4)
lab var agec4 "age groups (4 groups)"

recode age (0/17 = 1 "0-17") (18/max = 2 "18+"), gen(agec2)		 		   
lab var agec2 "age groups (2 groups)"



codebook h219, ta (9) 						// marital status

recode h219 (6=1 "never married") ///
(1 5 = 2 "currently married") (4=3 "widowed") ///
(3=4 "divorced") (2 = 5 "not living together"), gen (marital)	
lab var marital "marital status"
ta h219 marital, m


gen member = 1 								// hh size
bys hh_id: egen hhsize = sum(member)
lab var hhsize "household size"
ta hhsize, m



codebook region, ta(9)	 						// region

recode region (1=1 "Norte")(2=2 "Centro")(3=3 "México City") ///
(4=4 "Sur"), gen(region_n)

ta region region_n,m
rename region region_o
rename region_n region
lab var region "subnational region"


							// subnational region, harmonised over time
							
clonevar region_01 = region
lab var region_01 "hot: subnational region"
	


**# step 2: indicator construction


**## school attendance

codebook h217, ta (99)

recode h217 (1=1 "in sch") (2=0 "out of sch"), gen (att)
lab var att "sch att status"	
ta att, m 										// qc: missing replaced as '.'

	
gen	scheg_a = (age>=6 & age<=14)   				// qc: mpi - age range of elg
lab var scheg_a "mpi: elg for school att"


gen	scheg_u = (age>=6 & age<=12)    			// qc: dst - age range of elg
lab var scheg_u "dst: elg for school att"	


								// policy: >=2/3 elg pop have non-missing data 
								
foreach v in a u {										// a=mpi; u=dst	 
	 	
	gen tmp_`v' = 1 if scheg_`v'==1 & att!=. 		
	bys hh_id: egen hsattdt_`v' = sum(tmp_`v')	 	// elg & no missing data
	drop tmp_`v'
	
	bys hh_id: egen hscheg_`v' = sum(scheg_`v')  		// elg population

	replace hsattdt_`v' = hsattdt_`v'/hscheg_`v' 
	replace hsattdt_`v' = (hsattdt_`v'>=2/3)	 		
	ta hsattdt_`v', m							     	// qc: missing < 0.5% 	
}



foreach i in a u {							// school att indc (a=mpi; u=dst)

	gen tmp_`i' = (att==1) if scheg_`i'==1 & att!=.     		
	bys	hh_id: egen satt_`i' = min(tmp_`i') 
	replace satt_`i' = . if hsattdt_`i'==0	& satt_`i'==1			// policy
	replace satt_`i' = 1 if hscheg_`i'==0  						   // non-elg 
	drop tmp_`i'

	ta satt_`i', m
							
}

lab var satt_a "mpi: not deprived in satt"					
lab var satt_u "dst: not deprived in satt"



**## years of schooling

codebook h218a h218b, ta(99)

ta h218b h218a,m nol


gen eduyr = 0 if h218a<=1

replace eduyr = h218b if h218a==2 | h218a==5 

replace eduyr = h218b + 6 if h218a==3 | h218a==6

replace eduyr = h218b + 9 if h218a==4 | h218a==7

replace eduyr = h218b + 12 if h218a>=8 & h218a<=10

replace eduyr = h218b + 15 if h218a==11 | h218a==12

lab var eduyr "total years of schooling" 


replace eduyr = . if age<=eduyr & age>0 	 	// missing if eduyr >= age

ta eduyr, m



	/* note: all those who should have completed 6 years 
	of schooling from their starting sch age are counted 
	as eligible, as well as early starters (from age of 10)
	who uniqely have up to six years of schooling are eligible. */
	

											// formal sch age is from 6 years
gen edueg = (age>=12 & age!=.) | ((age==10 | age==11) & ///
			(eduyr>=6 & eduyr!=.)) | (age==. & eduyr>=6 & eduyr!=.)	
							 
lab var edueg "elg for years of schooling"
ta edueg,m



								// policy: >=2/3 elg pop have non-missing data 	
gen tmp = 1 if eduyr!=. & edueg==1
bys	hh_id: egen hedudt = sum(tmp)				// elg pop with no missing data
drop tmp				
	
bys hh_id: egen hedueg = sum(edueg==1) 			// elg population

replace hedudt = hedudt/hedueg
replace hedudt = (hedudt>=2/3)		
ta hedudt, m									// qc: missing < 0.5% 	
lab var hedudt "non-missing edu" 
							
									
									// mpi: completed six years of schooling
gen	tmp_a = (eduyr>=6 & eduyr!=. & edueg==1)   	
replace tmp_a = . if eduyr==. & edueg==1

									// dst: completed one year of schooling
gen	tmp_u = (eduyr>=1 & eduyr!=. & edueg==1)		
replace tmp_u = . if eduyr==. & edueg==1								
								
								
foreach i in a u {							
	bys hh_id: egen educ_`i' = max(tmp_`i')
	replace educ_`i' = . if educ_`i'==0 & hedudt==0 				// policy
	drop tmp_`i'
	
	ta educ_`i', m							
}
																
lab var educ_a "mpi: not deprived in yos"
lab var educ_u "dst: not deprived in yos"



**## nutrition

foreach msr in uw_st_a uw_st_u {	

	bys hh_id: egen tmp = max(`msr')
	gen	no_`msr' = (tmp==0)	if tmp!=.			
	drop tmp
	replace no_`msr' = 1 if no_ch_elg==1			// hh no elg child 

	ta no_`msr',m 
}

lab var no_uw_st_a "mpi: no underweight/stunted child in hh"
lab var no_uw_st_u "dst: no underweight/stunted child in hh"	


foreach i in a u {							 // nutr indc (a = mpi; u = dst)

gen	nutr1_`i' = 1  														
replace nutr1_`i' = 0 if no_uw_st_`i'==0
replace nutr1_`i' = . if no_uw_st_`i'==.
replace nutr1_`i' = 1 if no_ch_elg==1   	


ta nutr1_`i', m

}

lab var nutr1_a "mpi: not deprived in nutr (u5)"
lab var nutr1_u "dst: not deprived in nutr (u5)"



**## child mortality

gen cm9 = .
lab var cm9 "no child mortality data"

	

**## electricity 

codebook h507, ta (9)

recode h507 (2=0 "no") (1=1 "yes"), gen (elct)			// mpi = dst
lab var elct "not deprived in elct"

ta h507 elct,m
								


**## sanitation

desc h510 h511 h512 h513 

codebook h510 h512 h513, ta(9)


ta h510 h512,m

gen	sani_a = (h512<=2 & h513<=2) 						// mpi

replace sani_a = . if h512==. & h513==.



codebook h511

replace sani_a = 0 if h511==1				
lab var sani_a "mpi: not deprived in sani"




recode h512 (1 2 3 = 1 "yes") ///
(. = 0 "no"), gen(sani_u)   						  // dst

lab var sani_u "dst: not deprived in sani"

ta h512 sani_u, m

ta h510 sani_u, m



**## drinking water 

codebook h508, ta(99)	

recode h508 (1/5 = 1 "yes") ///
(6 = 0 "no"), gen(wtr7)						  // mpi

lab var wtr7 "not deprived in dwtr (no time data)"

ta h508 wtr7, m								



**## housing

desc h503 h502 h501


codebook h503, ta (99)			// improved = rudimentary & finished floor
 
recode h503 (2 3 = 1 "yes") (1 = 0 "no"), gen(floor)
lab var floor "hh has improved floor"
ta h503 floor,m


codebook h501, ta (99)					// improved = finished walls 

recode h501 (6/8 = 1 "yes") (1/5 = 0 "no"), gen(wall)
lab var wall "hh has improved wall"
ta h501 wall,m


codebook h502, ta (99)					// improved = finished roofing 

recode h502 (6/9 = 1 "yes") (1/5 = 0 "no"), gen(roof)
lab var roof "hh has improved roof"
ta h502 roof,m	



gen hsg_a = 1  														// mpi
replace hsg_a = 0 if floor==0 | wall==0 | roof==0
replace hsg_a = . if floor==. & wall==. & roof==.
lab var hsg_a "mpi: not deprived in hsg"
ta hsg_a, m



gen hsg_u = 1 														// dst
replace hsg_u = 0 if ///
(floor==0 & wall==0 & roof==1) | ///
(floor==0 & wall==1 & roof==0) | ///
(floor==1 & wall==0 & roof==0) | ///
(floor==0 & wall==0 & roof==0)

replace hsg_u = . if floor==. & wall==. & roof==.
lab var hsg_u "dst: not deprived in hsg"
ta hsg_u, m



**## cooking fuel
	
codebook h514, ta(99) 

recode h514 (1/2 5 6 = 1 "yes")(3/4 = 0 "no"), gen(ckfl)

lab var ckfl "not deprived in ckfl"	
								
ta h514 ckfl,m



**## assets

lookfor automóvil camioneta
ta h60102 h60103, m nol

gen car = (h60102==1 | h60103==1)
replace car = . if h60102==9 & h60103==9
lab var car "hh has car"	
ta h60102 h60103 if car==1,m



lookfor téléphone ipod telefone tele celular 
ta h60120 h60124, m nol

gen phone = (h60120==1 | h60124==1)
replace phone = . if h60120 ==9 & h60124==9
lab var phone "hh has phone"	
ta h60120 h60124 if phone==1,m			



lookfor radio walkman stereo stéréo estreo
codebook h60108 h60109
clonevar radio = h60108
lab var radio "hh has radio"


lookfor tv television plasma lcd télé tele
codebook h60106 h60107
clonevar tv = h60106
lab var tv "hh has television"


lookfor refrigerator réfrigérateur refri freezer
codebook h60112 
clonevar fridge = h60112 
lab var fridge "hh has refrigerator"


lookfor motorbike moto motocicleta
codebook h60104 	
clonevar mbike = h60104 
lab var mbike "hh has motorbike"


lookfor computadora  ordinateur laptop ipad tablet 
codebook h60117
clonevar comp = h60117
lab var comp "hh has computer"



lab def la_at 0"no" 1"yes" 
foreach var in car phone radio tv fridge mbike comp {
replace `var' = 0 if `var'==2 
lab val `var' la_at			   
replace `var' = . if `var'==9 | `var'==99 | `var'==8 | `var'==98 
}


egen n_bast5 = rowtotal (phone radio tv fridge mbike comp), m
lab var n_bast5 "basic assets owned by hh (excl bike & acart)" 
 
 
gen asst5_a = (car==1 | n_bast5 > 1)   							// mpi
replace asst5_a = . if car==. & n_bast5==.
lab var asst5_a "mpi: not deprived in assets (excl bike & acart)"



gen	asst5_u = (car==1 | n_bast5 > 0)  						 // dst
replace asst5_u = . if car==. & n_bast5==.
lab var asst5_u "dst: not deprived in assets (excl bike & acart)"



**# step 3: spec & flav

recode cm9   	(0=1)(1=0) , gen(d_cm)						// MPI est 
recode nutr1_a 	(0=1)(1=0) , gen(d_nutr)
recode satt_a 	(0=1)(1=0) , gen(d_satt)
recode educ_a 	(0=1)(1=0) , gen(d_educ)
recode elct		(0=1)(1=0) , gen(d_elct)
recode wtr7 	(0=1)(1=0) , gen(d_wtr)
recode sani_a	(0=1)(1=0) , gen(d_sani)
recode hsg_a 	(0=1)(1=0) , gen(d_hsg)
recode ckfl 	(0=1)(1=0) , gen(d_ckfl)
recode asst5_a 	(0=1)(1=0) , gen(d_asst)


recode cm9   	(0=1)(1=0) , gen(d_cm_01)	 			    // hot MPI est 
recode nutr1_a 	(0=1)(1=0) , gen(d_nutr_01)
recode satt_a 	(0=1)(1=0) , gen(d_satt_01)
recode educ_a 	(0=1)(1=0) , gen(d_educ_01)
recode elct		(0=1)(1=0) , gen(d_elct_01)
recode wtr7 	(0=1)(1=0) , gen(d_wtr_01)
recode sani_a	(0=1)(1=0) , gen(d_sani_01)
recode hsg_a 	(0=1)(1=0) , gen(d_hsg_01)
recode ckfl 	(0=1)(1=0) , gen(d_ckfl_01)
recode asst5_a 	(0=1)(1=0) , gen(d_asst_01)



recode cm9   	(0=1)(1=0) , gen(dst_cm)					// dst est
recode nutr1_u 	(0=1)(1=0) , gen(dst_nutr)
recode satt_u 	(0=1)(1=0) , gen(dst_satt)
recode educ_u 	(0=1)(1=0) , gen(dst_educ)
recode elct 	(0=1)(1=0) , gen(dst_elct)
recode wtr7  	(0=1)(1=0) , gen(dst_wtr)
recode sani_u 	(0=1)(1=0) , gen(dst_sani)
recode hsg_u  	(0=1)(1=0) , gen(dst_hsg)
recode ckfl 	(0=1)(1=0) , gen(dst_ckfl)
recode asst5_u 	(0=1)(1=0) , gen(dst_asst) 


recode cm9   	(0=1)(1=0) , gen(dst_cm_01)				   	 // hot dst est
recode nutr1_u	(0=1)(1=0) , gen(dst_nutr_01)
recode satt_u 	(0=1)(1=0) , gen(dst_satt_01)
recode educ_u 	(0=1)(1=0) , gen(dst_educ_01)
recode elct 	(0=1)(1=0) , gen(dst_elct_01)
recode wtr7  	(0=1)(1=0) , gen(dst_wtr_01)
recode sani_u 	(0=1)(1=0) , gen(dst_sani_01)
recode hsg_u  	(0=1)(1=0) , gen(dst_hsg_01)
recode ckfl 	(0=1)(1=0) , gen(dst_ckfl_01)
recode asst5_u 	(0=1)(1=0) , gen(dst_asst_01) 



lab def la_dp 1"yes" 0"no"
foreach var in d_* dst_* d_*_* dst_*_* {
lab val `var' la_dp
}

foreach var in cm nutr satt educ elct wtr sani hsg ckfl asst {
lab var d_`var' "deprived in `var'"
lab var d_`var'_01 "hot: deprived in `var'"
lab var dst_`var' "dst: deprived in `var'"
lab var dst_`var'_01 "hot-dst: deprived in `var'"
}


rename hh_id hhid_str
egen hh_id = group(hhid_str)


keep hh_id ind_id strata psu weight chswgt ///
sex age agec* area region* hship  ///
scheg_a att edueg eduyr ///
chelg underweight_a stunted_a uw_st_a ///
d_* dst_*  

	 
order hh_id ind_id strata psu weight chswgt ///
sex age agec* area region* hship  ///
scheg_a att edueg eduyr ///
chelg underweight_a stunted_a uw_st_a ///
d_* dst_* 


mdesc psu strata area age hship region* d_* dst_*


char _dta[cty] "Mexico"
char _dta[ccty] "MEX"
char _dta[year] "2016" 	
char _dta[survey] "ENSANUT"
char _dta[ccnum] "484"
char _dta[type] "micro"


sort ind_id
compress
la da "Micro data for `_dta[ccty]' (`_dta[ccnum]') from `c(current_date)' (`c(current_time)')."
save "$path_out/mex_ensanut16.dta", replace 