
** Global Multidimensional Poverty Index - Cote d'Ivoire MICS 2016 **

clear all 
set more off
set maxvar 10000


global path_in "../rdta/Cote d'Ivoire MICS 2016"   			// folder path
global path_out "cdta"
global path_ado "ado"


**# step 1: data cleaning


**## child under 5	


use "$path_in/ch.dta", clear 

rename _all, lower


gen double ind_id = hh1*10000 + hh2*100 + ln 
format ind_id %20.0g


duplicates report ind_id								// qc: no duplicates



gen chelg = 1
lab var chelg "child eligible for measurement" 
count


codebook hl4, ta (9) 									// sex
clonevar gender = hl4									// qc: 1=male; 2=female 


desc cage  							// qc: use age in months 
clonevar age = cage 
su age								// qc: check min & max value


gen str6 ageunit = "months"
lab var ageunit "months"


codebook an3, ta (999) 					// qc: body weight in kg

clonevar weight = an3 if an3<99			// qc: out of range value 
ta an2 an3 if an3==., m  				// qc: why missing	
su weight


codebook an4, ta (999) 					// qc: height in cm

clonevar height = an4 if an4<900  		// qc: out of range value
ta an2 an4 if an4>=999 | an4==., m		// qc: why missing
su height
	
	
codebook an4a  									// how child was measured

gen measure = "l" if an4a==1 					// lying down
replace measure = "h" if an4a==2 				// standing up
replace measure = " " if an4a>=9 | an4a==.		// " " if unknown
ta measure 

		
gen str1 oedema = "n"  									// oedema


gen sw = 1												// sampling weight


clonevar chswgt = chweight		
lab var chswgt "sample weight child u5"	



adopath + "$path_ado/igrowup_stata"			     		// compute z-score
gen str100 reflib = "$path_ado/igrowup_stata"
lab var reflib "Directory of reference tables"
gen str100 datalib = "$path_out" 
lab var datalib "Directory for datafiles"
gen str30 datalab = "ch_civ"
lab var datalab "Working file"


igrowup_restricted reflib datalib datalab gender age ///
ageunit weight height measure oedema sw


use "$path_out/ch_civ_z_rc.dta", clear 


foreach m of newlist wei len wfl {

	gen	`m'_a = (_z`m' < -2.0)    									// a = mpi
	replace `m'_a = . if _z`m' == . | _f`m'==1

	gen	`m'_u = (_z`m' < -3.0) 										// u = dst
	replace `m'_u = . if _z`m' == . | _f`m'==1
		
}


rename (wei_a len_a wfl_a) (underweight_a stunted_a wasted_a)
rename (wei_u len_u wfl_u) (underweight_u stunted_u wasted_u)

	
foreach i in underweight stunted wasted {	
	lab var `i'_a  "mpi: child is `i'"
	lab var `i'_u  "dst: child is `i'"
	
	ta `i'_a [aw=chswgt],m                      // qc: % underweight; stunted 
	ta `i'_u [aw=chswgt],m 
}


												// union underweight-stunted
foreach v in a u {								

gen uw_st_`v' = 1 if stunted_`v'==1 | underweight_`v'==1		
replace uw_st_`v' = 0 if stunted_`v'==0 & underweight_`v'==0
replace uw_st_`v' = . if stunted_`v'==. & underweight_`v'==.

}

lab var uw_st_a "mpi: child is uwgt/stunted"   			
lab var uw_st_u "dst: child is uwgt/stunted"  			



count if _fwei==1 | _flen==1  				// biologically implausible zscore 
  

keep *_id chelg chswgt underweight* stunted* wasted* uw_st*
order *_id chelg chswgt underweight* stunted* wasted* uw_st*
sort ind_id
save "$path_out/CIV16_CH.dta", replace



erase "$path_out/ch_civ_z_rc.xls" 				// erase files
erase "$path_out/ch_civ_prev_rc.xls"
erase "$path_out/ch_civ_z_rc.dta"



**## birth history

use "$path_in/bh.dta", clear

rename _all, lower	


gen double ind_id = hh1*10000 + hh2*100 + ln
format ind_id %20.0g


gen bh_id = 1
lab var bh_id "female birth recode" 


	
desc bh4c bh5 bh9c wdoi		// dob cmc; child is alive; age at dth mth; doi cmc

codebook bh5 				// qc: 1=alive; 2=not alive

sum bh9c 					// qc: child not alive; age at dth  

recode bh5 (1=0 "alive")(2=1 "not alive"), gen (chdth) // total child deceased 


bys ind_id: egen fchdth = sum(chdth)


recode chdth (1=1 "childu18 death") (0=0 "older/no death"), gen (ch18dth)
replace ch18dth=0 if bh9c>=216 & bh9c!=. 

ta ch18dth, m 								// total child under 18 deceased


gen ydth_svy= (wdoi - (bh4c + bh9c)) / 12 	 			// dod = bh4c + bh9c 
lab var ydth_svy "years deceased from svy year"
su ydth_svy


bys ind_id: egen fch18dth=sum(ch18dth) if ydth_svy<=5 

replace fch18dth=0 if fch18dth==. & fchdth>=0 & fchdth!=.
	/* note: all children who are alive or who died longer 
	than 5 years from the interview date are replaced as '0' */

replace fch18dth=. if ch18dth==1 & ydth_svy==.  // missing data on death year

ta fchdth fch18dth, m


bys ind_id: egen bh_cm = max(fch18dth)
lab var bh_cm "total cm reported by female"	
ta bh_cm,m


bys ind_id: gen id=1 if _n==1
keep if id==1								// keep one observation per female
drop id
duplicates report ind_id 					


keep *_id bh_cm		
order *_id bh_cm
sort ind_id
save "$path_out/CIV16_BH.dta", replace	



**## eligible female

use "$path_in/wm.dta", clear 
	
rename _all, lower	


gen double ind_id = hh1*10000 + hh2*100 + ln
format ind_id %20.0g

duplicates report ind_id 							// qc: no duplicates


gen fm_id = 1 
lab var fm_id "female recode file"


ta wb2,m 										 // qc: age 15-49 

codebook cm1 cm8 cm9a cm9b cm10, ta (999)		// qc: check why missing values 

ta cm1 cm8, m							// never gave birth, but reported cm
	

	
codebook mstatus ma6, ta (9)
ta mstatus ma6, m 

gen marf = 1 if mstatus==3 							// never married 
replace marf = 2 if mstatus==1 			     		// married 
replace marf = 3 if ma6==1				 			// widowed
replace marf = 4 if ma6==2 			    			// divorced 
replace marf = 5 if ma6==3					 		// separated
lab def la_ma 1"never married" 2"currently married" ///
3"widowed" 4"divorced" 5"not living together"
lab val marf la_ma	
lab var marf "marital status female"
ta marf, m
ta ma6 marf, m
ta mstatus marf, m


keep *_id cm1 cm8 cm9a cm9b cm10 marf 
order *_id cm1 cm8 cm9a cm9b cm10 marf 
sort ind_id
save "$path_out/CIV16_FM.dta", replace



**## female 15-19	

use "$path_in/wm.dta", clear 
	
rename _all, lower	


gen double ind_id = hh1*10000 + hh2*100 + ln
format ind_id %20.0g

duplicates report ind_id 					// qc: no duplicates


count if wb2>=15 & wb2<=19

keep if wb2>=15 & wb2<=19					// keep only relevant sample


gen gender = 2 									 // 2: female 


desc wb1m wb1y
codebook wb1m wb1y, ta (99)						// birth month & year 

clonevar wb1m_1 = wb1m if wb1m<=12				 
clonevar wb1y_1 = wb1y if wb1y<=2006			// qc: missing values replaced

gen bmth = mdy(wb1m_1, 1, wb1y_1) 				// birth date in months


desc wm6m wm6y									// measurment dates
codebook wm6m wm6y, ta (99) 
	   
gen imth = mdy(wm6m, 1, wm6y) 					// measurement dates in months


gen age_month = (imth-bmth)/30.435				// age in months
lab var age_month "age (months) girl 15-19"

su age_month
count if age_month <= 228


gen str6 ageunit = "months" 
lab var ageunit "months"


codebook wan3, ta (999) 					// qc: body weight in kg

clonevar weight = wan3 if wan3<900
su weight 


codebook wan4, ta (999)						// qc: height in cm

clonevar height = wan4 if wan4<900
su height 


gen oedema = "n"  								// oedema


gen sw = 1 										// sampling weight


adopath + "$path_ado/who2007_stata"				// compute z-score
gen str100 reflib = "$path_ado/who2007_stata"
lab var reflib "directory of reference tables"
gen str100 datalib = "$path_out" 
lab var datalib "directory for datafiles"
gen str30 datalab = "ng_civ" 
lab var datalab "working file"
	
who2007 reflib datalib datalab gender age_month ///
ageunit weight height oedema sw

use "$path_out/ng_civ_z.dta", clear 


foreach m of newlist bfa {

	gen	`m'_a = (_z`m' < -2.0)    									// a = mpi
	replace `m'_a = . if _z`m' == . | _f`m'==1

	gen	`m'_u = (_z`m' < -3.0) 										// u = dst
	replace `m'_u = . if _z`m' == . | _f`m'==1
		
}


rename (bfa_a bfa_u age_month) (f_lbmiag_a f_lbmiag_u f_agmth)

lab var f_lbmiag_a "mpi: low bmi-for-age fem"
lab var f_lbmiag_u "dst: low bmi-for-age fem"

	
foreach i in f_lbmiag {	
	
	ta `i'_a,m                       	
	ta `i'_u,m 
}


keep *_id f_* wan3 wan4
order *_id f_* wan3 wan4
sort ind_id


save "$path_out/CIV16_NG.dta", replace



erase "$path_out/ng_civ_z.xls"  			// erase files
erase "$path_out/ng_civ_prev.xls"
erase "$path_out/ng_civ_z.dta"



**## hh recode

use "$path_in/hh.dta", clear									

rename _all, lower	


gen	double hh_id = hh1*100 + hh2 
format	hh_id %20.0g

duplicates report hh_id					 				// qc: no duplicates


save "$path_out/CIV16_HH.dta", replace



**## hh members

use "$path_in/hl.dta", clear 									

rename _all, lower	

										
gen double hh_id = hh1*100 + hh2 
format hh_id %20.0g
lab var hh_id "household id"


gen double ind_id = hh1*10000 + hh2*100 + hl1
format ind_id %20.0g
lab var ind_id "individual id"


duplicates report ind_id 


sort ind_id

 
 
bys hh_id: gen id = _n
count if id==1						// qc: 11,879 hh - matches report, p.XIX 
 


**## data merging

merge 1:1 ind_id using "$path_out/CIV16_BH.dta"  			 // bh recode
drop _merge
erase "$path_out/CIV16_BH.dta"


merge 1:1 ind_id using "$path_out/CIV16_FM.dta" 			 // fem recode
drop _merge
erase "$path_out/CIV16_FM.dta"
	

merge 1:1 ind_id using "$path_out/CIV16_NG.dta"				// girl 15-19
drop _merge
erase "$path_out/CIV16_NG.dta"	
	

merge 1:1 ind_id using "$path_out/CIV16_CH.dta"  			// ch recode
drop _merge
erase "$path_out/CIV16_CH.dta"


merge m:1 hh_id using "$path_out/CIV16_HH.dta" 				// hh recode
ta hh9 if _m==2 
drop if _merge==2									// drop hh not interviewed 
drop _merge
erase "$path_out/CIV16_HH.dta"


sort ind_id



**## eligibility variables		
						
															// elg for cm
																
count if fm_id==1						
count if hl7>0 & hl7!=.					// qc: match between wm & hl datafiles 

bys hh_id: egen no_f_elg = min(fm_id==.)
lab var no_f_elg "hh has no elg female"
ta no_f_elg,m


																// elg for nutr
																
gen no_fnu_elg = (no_f_elg==1)		
lab var no_fnu_elg "hh has no elg female for nutr"
ta no_fnu_elg, m
					
					
count if chelg==1
count if hl7b>0 & hl7b!=.			// qc: match between ch and hl datafiles


bys hh_id: egen no_ch_elg = min(chelg==.)
lab var no_ch_elg "hh has no elg child for nutr"
ta no_ch_elg,m



sort hh_id 



**## relevant variables 

clonevar weight = hhweight 								// sample weight 
lab var weight "sample weight"
	
	
gen psu = hh1				
lab var psu "primary sampling unit"					  	// sample design	

clonevar strata = stratum
lab var strata "sample strata"

svyset psu [pw=weight] , strata(strata)	 singleunit(centered)



desc hh5y hh5m hh5d 								// interview dates

clonevar intvw_y = hh5y 	
clonevar intvw_m = hh5m 
clonevar intvw_d = hh5d 



codebook hh6, ta (9)									// area: urban-rural
		
recode hh6 (1=1 "urban") (2=0 "rural"), gen (area)						 
lab var area "area"
ta hh6 area, m



codebook hl3, ta (99)									     // relationship

recode hl3 (1=1 "head")(2=2 "spouse")(3 13=3 "child") ///
(4/12=4 "extended family")(96=5 "not related")(14=6 "maid") ///
(97 98=.), gen (rship)
lab var rship "relationship"
ta hl3 rship, m	



codebook hl4 													// sex

recode hl4 (1=1 "male")	(2=2 "female"), gen (sex)						
lab var sex "sex"
ta hl4 sex,m



bys	hh_id: egen xhhead = min(rship) 						// headship
ta xhhead,m 

gen hhead = (rship==1 & sex==1) | (xhhead==2 & rship==2 & sex==1) 
replace hhead = 2 if (rship==1 & sex==2) | (xhhead==2 & rship==2 & sex==2) 

bys hh_id: egen hship = sum(hhead) 

replace hship = . if xhhead > 2 | hship==0  		// hh, no head
lab def la_hs 1"male-headed" 2"female-headed"
lab val hship la_hs
lab var hship "gender of hh head"
ta hship, m	 



codebook hl6, ta (999) 										// age; age group

clonevar age = hl6  if hl6<98
lab var age "age"


recode age (0/4 = 1 "0-4")(5/9 = 2 "5-9")(10/14 = 3 "10-14") ///
		   (15/17 = 4 "15-17")(18/59 = 5 "18-59")(60/max=6 "60+"), gen(agec7)
lab var agec7 "age groups (7 groups)"	
	   
recode age (0/9 = 1 "0-9") (10/17 = 2 "10-17")(18/59 = 3 "18-59") ///
		   (60/max=4 "60+") , gen(agec4)
lab var agec4 "age groups (4 groups)"

recode age (0/17 = 1 "0-17") (18/max = 2 "18+"), gen(agec2)		 		   
lab var agec2 "age groups (2 groups)"



gen member = 1 												// hh size
bys hh_id: egen hhsize = sum(member)
lab var hhsize "household size"
compare hhsize hh11  					// qc: hh48 matches generated hhsize  
drop member



codebook hh7, ta (99) 										//  region

recode hh7 (1=1 "Centre") (2=2 "Centre-Est") ///
(3=3 "Centre-Nord") (4=4 "Centre-Ouest") ///
(5=5 "Nord") (6=6 "Nord-Est") (7=7 "Nord-Ouest") ///
(8=8 "Ouest") (9=9 "Sud (ex. Abidjan)") ///
(10=10 "Sud-Ouest") (11=11 "Abidjan"), into (region)

lab var region "subnational region" 	
codebook region, ta (99)


									// subnational region, harmonised over time

gen region_01 = .
lab var region_01 "hot: subnational region"



**# step 2: indicator construction


**## school attendance


codebook ed5 ed3, ta (99)

recode ed5 (1=1 "attending") (2=0 "not attending") (9=.), gen (att)
replace att = 0 if ed3==2 						// never attended school			
lab var att "sch att status"
ta att,m 										// qc: missing replaced as '.'



gen scheg_a = (schage>=6 & schage<=14)			// qc: mpi - age range of elg
lab var scheg_a "mpi: elg for school att"


gen scheg_u = (schage>=6 & schage<=12)			// qc: dst - age range of elg
lab var scheg_u "dst: elg for school att"


								// policy: >=2/3 elg pop have non-missing data 
								
foreach v in a u {										// a=mpi; u=dst	 
	 	
	gen tmp_`v' = 1 if scheg_`v'==1 & att!=. 		
	bys hh_id: egen hsattdt_`v' = sum(tmp_`v')	 	// elg & no missing data
	drop tmp_`v'
	
	bys hh_id: egen hscheg_`v' = sum(scheg_`v')  		// elg population

	replace hsattdt_`v' = hsattdt_`v'/hscheg_`v' 
	replace hsattdt_`v' = (hsattdt_`v'>=2/3)	 		
	ta hsattdt_`v', m							     	// qc: missing < 0.5% 	
}


foreach i in a u {							// school att indc (a=mpi; u=dst)

	gen tmp_`i' = (att==1) if scheg_`i'==1 & att!=.     		
	bys	hh_id: egen satt_`i' = min(tmp_`i') 
	replace satt_`i' = . if hsattdt_`i'==0	& satt_`i'==1			// policy
	replace satt_`i' = 1 if hscheg_`i'==0  						   // non-elg 
	drop tmp_`i'

	ta satt_`i', m
							
}

lab var satt_a "mpi: not deprived in satt"					
lab var satt_u "dst: not deprived in satt"



**## years of schooling 

codebook ed4a ed3, ta (99)

clonevar edulev = ed4a if ed4a<8				// qc: missing value

replace edulev = 0 if ed3==2 					// never attended school 



codebook ed4b, ta (99)								

clonevar eduhyr = ed4b if ed4b < 90 		 	// qc: missing value

replace eduhyr = 0 if ed3==2 | ed4a<1			// never attended or preschool 



ta eduhyr edulev,m

gen eduyr = eduhyr
	
replace eduyr = eduhyr + 6 if edulev==2
	// secondary school following 6 years of primary
	
replace eduyr = eduhyr + 13 if edulev==3   
	// higher education following 13 years educ 
	

replace eduyr = 6 if (edulev==2 & eduhyr==.) 	
	/* assume completion of 6 yrs of schooling 
	if secondary is the highest level of educ */ 
	
replace eduyr = 13 if (edulev==3 & eduhyr==.) 	
	/* assume completion of 13 yrs of schooling 
	if tertiary is the highest level of educ */

	
replace eduyr = . if age<=eduyr & age>0 

ta eduyr, m


	/* note: all those who should have completed 6 years 
	of schooling from their starting sch age are counted 
	as eligible, as well as early starters (from age of 10)
	who uniqely have up to six years of schooling are eligible. */
	

											// formal sch age is from 6 years
gen edueg = (age>=12 & age!=.) | ((age==10 | age==11) & ///
			(eduyr>=6 & eduyr!=.)) | (age==. & eduyr>=6 & eduyr!=.)	
								 
lab var edueg "elg for years of schooling"
ta edueg,m


								// policy: >=2/3 elg pop have non-missing data 
								
gen tmp = 1 if eduyr!=. & edueg==1
bys	hh_id: egen hedudt = sum(tmp)				// elg pop with no missing data
drop tmp				
	
bys hh_id: egen hedueg = sum(edueg==1) 			// elg population

replace hedudt = hedudt/hedueg
replace hedudt = (hedudt>=2/3)		
ta hedudt, m									// qc: missing < 0.5% 	
lab var hedudt "non-missing edu" 
							
							
									// mpi: completed six years of schooling
gen	tmp_a = (eduyr>=6 & eduyr!=. & edueg==1)   	
replace tmp_a = . if eduyr==. & edueg==1

									// dst: completed one year of schooling
gen	tmp_u = (eduyr>=1 & eduyr!=. & edueg==1)		
replace tmp_u = . if eduyr==. & edueg==1								
								
								
foreach i in a u {							
	bys hh_id: egen educ_`i' = max(tmp_`i')
	replace educ_`i' = . if educ_`i'==0 & hedudt==0 				// policy
	drop tmp_`i'
	
	ta educ_`i', m							
}
																
lab var educ_a "mpi: not deprived in yos"
lab var educ_u "dst: not deprived in yos"
	


**## nutrition
															
gen f_bmi = wan3/((wan4/100)^2)


gen f_lbmi_a = (f_bmi<18.5)
lab var f_lbmi_a "mpi: female low bmi "


gen f_lbmi_u = (f_bmi<17)  					
lab var f_lbmi_u "dst: female low bmi"


replace f_lbmi_a = 0 if f_lbmiag_a==0 & f_agmth!=.  
replace f_lbmi_u = 0 if f_lbmiag_u==0 & f_agmth!=.  	
 // note: 15-19 with healthy bmi-for-age are replaced as non-low bmi

	
	
foreach v in a u {								 		
		
	bys hh_id: egen tmp_`v' = max(f_lbmi_`v')
	gen	no_flowbmi_`v' = (tmp_`v'==0) if tmp_`v'!=.	
	
	replace no_flowbmi_`v' = 1 if no_fnu_elg==1			// hh no elg female  

	drop tmp_`v'

	ta no_flowbmi_`v', m
}													

lab var no_flowbmi_a "mpi: no underweight female in hh"
lab var no_flowbmi_u "dst: no underweight female in hh"														

	
foreach msr in uw_st_a uw_st_u {	

	bys hh_id: egen tmp = max(`msr')
	gen	no_`msr' = (tmp==0)	if tmp!=.			
	drop tmp
	replace no_`msr' = 1 if no_ch_elg==1			// hh no elg child 

	ta no_`msr',m 
}

lab var no_uw_st_a "mpi: no underweight/stunted child in hh"
lab var no_uw_st_u "dst: no underweight/stunted child in hh"	
	
	
	
	
foreach i in a u {							 // nutr indc (a = mpi; u = dst)

gen	nutr1_`i' = 1  														
replace nutr1_`i' = 0 if no_uw_st_`i'==0
replace nutr1_`i' = . if no_uw_st_`i'==.	


gen	nutr2_`i' = 1
replace nutr2_`i' = 0 if no_flowbmi_`i'==0 | no_uw_st_`i'==0
replace nutr2_`i' = . if (no_flowbmi_`i'==. & no_uw_st_`i'==.)  | ///
					   (no_flowbmi_`i'==. & no_uw_st_`i'==1 & no_ch_elg==1) | ///
					   (no_uw_st_`i'==. & no_flowbmi_`i'==1 & no_fnu_elg==1)


ta nutr1_`i', m
ta nutr2_`i', m

}

lab var nutr1_a "mpi: not deprived in nutr (u5)"
lab var nutr1_u "dst: not deprived in nutr (u5)"
lab var nutr2_a "mpi: not deprived in nutr (u5 & fem)"
lab var nutr2_u "dst: not deprived in nutr (u5 & fem)"



**## child mortality
	
ta bh_cm,m   										// generated in bh recode
ta bh_cm if bh_id==1, m	


gen tmp = bh_cm

							// zero death = no child died, non-elg fem
ta cm1 cm8,m

replace tmp = 0 if cm8==2 | no_f_elg==1 		
														
bys hh_id: egen cm = sum(tmp),m			
	
	
recode cm (1/max=0) (0=1) if cm!=.
lab var cm "not deprived in cm"
ta cm, m 														// mpi = dst

drop tmp 



**## electricity 

codebook hc8a, ta (9)

recode hc8a  (1 = 1 "yes") (2 = 0 "no") (9=.), gen(elct)	 
lab var elct "not deprived in elct"								// mpi = dst


svy: prop elct 							



**## sanitation

desc ws8 ws9

codebook ws8, ta(99) 	
	
recode ws8 (11/13 15/22 31 = 1 "yes") ///
(14 23 41/96 = 0 "no") (99=.), gen(sani_a)   						// mpi

ta ws8 sani_a,m


codebook ws9

replace sani_a = 0 if ws9==1				
lab var sani_a "mpi: not deprived in sani"


						
						
	
recode ws8 (11/51 = 1 "yes") ///
(95 96 = 0 "no") (99=.), gen(sani_u)   								// dst

lab var sani_u "dst: not deprived in sani"
ta ws8 sani_u, m



**## drinking water 

desc ws1 ws4 

codebook ws1, ta(99)

recode ws1 (11/31 41 51/71 91 92 = 1 "yes") ///
(32 42 81 96 = 0 "no") (99=.), gen(wtr_sdg)

lab var wtr_sdg "improved source of dwtr sdg"

ta ws1 wtr_sdg


codebook ws4, ta (999)									// time to water

clonevar wtr_a = wtr_sdg
replace wtr_a = 0 if ws4 >=30 & ws4 <=900				// mpi >=30 mins	 
lab var wtr_a "mpi: not deprived in dwtr"
ta wtr_a,m


clonevar wtr_u = wtr_sdg															   
replace wtr_u = 0 if ws4 >45 & ws4 <=900				// dst > 45 mins			  
lab var wtr_u "dst: not deprived in dwtr"
ta wtr_u,m 



**## housing

desc hc3 hc4 hc5

codebook hc3, ta (99)			// improved = rudimentary & finished floor

recode hc3 (31/35 = 1 "yes") (11 12 96 = 0 "no") (99=.), gen(floor)
lab var floor "hh has improved floor"
ta hc3 floor,m


codebook hc5, ta (99)					// improved = finished walls 

recode hc5 (31/37 = 1 "yes") (11/26 96 = 0 "no") (99=.), gen(wall)
lab var wall "hh has improved wall"
ta hc5 wall,m


codebook hc4, ta (99)					// improved = finished roofing
 
recode hc4 (31/36 = 1 "yes") (11/24 96 = 0 "no") (99=.), gen(roof)
lab var roof "hh has improved roof"
ta hc4 roof,m	


gen hsg_a = 1  														// mpi
replace hsg_a = 0 if floor==0 | wall==0 | roof==0
replace hsg_a = . if floor==. & wall==. & roof==.
lab var hsg_a "mpi: not deprived in hsg"
ta hsg_a, m



gen hsg_u = 1 														// dst
replace hsg_u = 0 if ///
(floor==0 & wall==0 & roof==1) | ///
(floor==0 & wall==1 & roof==0) | ///
(floor==1 & wall==0 & roof==0) | ///
(floor==0 & wall==0 & roof==0)

replace hsg_u = . if floor==. & wall==. & roof==.
lab var hsg_u "dst: not deprived in hsg"
ta hsg_u, m



**## cooking fuel 

codebook hc6, ta (99)

recode hc6 (1/2 95 96 = 1 "yes") ///
(6/10 = 0 "no") (99=.), gen(ckfl) 							// mpi = dst

lab var ckfl "not deprived in ckfl"	

ta hc6 ckfl,m 
							

							
**## assets

lookfor car van truck camion
codebook hc9f	
clonevar car = hc9f  
lab var car "hh has car"
	

lookfor telephone téléphone mobile phone ipod telefone tele celular
ta hc8d hc9b,m nol
ta hc9b hc9n,m nol
gen phone = (hc8d==1 | hc9b==1 | hc9n==1)
replace phone=. if hc8d==9 & hc9b==9 & hc9n==9
lab var phone "hh has telephone"			


lookfor radio walkman stereo stéréo
codebook hc8b
clonevar radio = hc8b
lab var radio "hh has radio"


lookfor tv television plasma lcd télé tele
codebook hc8c
clonevar tv = hc8c 
lab var tv "hh has television"


lookfor refrigerator réfrigérateur refri freezer
codebook hc8e 
clonevar fridge = hc8e
lab var fridge "hh has refrigerator"


lookfor bicycle bicyclette bicicleta tricycle
ta hc9c hc9h,m nol  
gen bike = (hc9c==1 | hc9h==1)
lab var bike "hh has bicycle"
ta hc9c hc9h if bike==1,m


lookfor mbike moto
codebook hc9d	
clonevar mbike = hc9d
lab var mbike "hh has motorbike"


lookfor brouette cart carro charrette 
codebook hc9e
clonevar acart = hc9e
lab var acart "hh has animal cart"	


lookfor computer ordinateur laptop ipad tablet 
ta hc9l hc9m,m nol 
gen comp = (hc9l==1 | hc9m==1) 
replace comp = . if hc9l==9 & hc9m==9
lab var comp "hh has computer"
ta hc9l hc9m if comp==1,m


	
lab def la_at 0"no" 1"yes" 
foreach var in car phone radio tv fridge bike mbike acart comp {
replace `var' = 0 if `var'==2 
lab val `var' la_at			   
replace `var' = . if `var'==9 | `var'==99 | `var'==8 | `var'==98 
}



egen n_bast = rowtotal (phone radio tv fridge bike mbike acart comp), m
lab var n_bast "basic assets owned by hh" 
 
 
gen asst_a = (car==1 | n_bast > 1)   							// mpi
replace asst_a = . if car==. & n_bast==.
lab var asst_a "mpi: not deprived in assets"



gen	asst_u = (car==1 | n_bast > 0)  						 // dst
replace asst_u = . if car==. & n_bast==.
lab var asst_u "dst: not deprived in assets"



**# step 3: spec & flav

recode cm   	(0=1)(1=0) , gen(d_cm)						// mpi est 
recode nutr2_a 	(0=1)(1=0) , gen(d_nutr)
recode satt_a 	(0=1)(1=0) , gen(d_satt)
recode educ_a 	(0=1)(1=0) , gen(d_educ)
recode elct		(0=1)(1=0) , gen(d_elct)
recode wtr_a 	(0=1)(1=0) , gen(d_wtr)
recode sani_a	(0=1)(1=0) , gen(d_sani)
recode hsg_a 	(0=1)(1=0) , gen(d_hsg)
recode ckfl 	(0=1)(1=0) , gen(d_ckfl)
recode asst_a 	(0=1)(1=0) , gen(d_asst)


recode cm   	(0=1)(1=0) , gen(d_cm_01)	 			    // hot mpi est 
recode nutr2_a 	(0=1)(1=0) , gen(d_nutr_01)
recode satt_a 	(0=1)(1=0) , gen(d_satt_01)
recode educ_a 	(0=1)(1=0) , gen(d_educ_01)
recode elct		(0=1)(1=0) , gen(d_elct_01)
recode wtr_a 	(0=1)(1=0) , gen(d_wtr_01)
recode sani_a	(0=1)(1=0) , gen(d_sani_01)
recode hsg_a 	(0=1)(1=0) , gen(d_hsg_01)
recode ckfl 	(0=1)(1=0) , gen(d_ckfl_01)
recode asst_a 	(0=1)(1=0) , gen(d_asst_01)



recode cm   	(0=1)(1=0) , gen(dst_cm)						// dst est
recode nutr2_u 	(0=1)(1=0) , gen(dst_nutr)
recode satt_u 	(0=1)(1=0) , gen(dst_satt)
recode educ_u 	(0=1)(1=0) , gen(dst_educ)
recode elct 	(0=1)(1=0) , gen(dst_elct)
recode wtr_u  	(0=1)(1=0) , gen(dst_wtr)
recode sani_u 	(0=1)(1=0) , gen(dst_sani)
recode hsg_u  	(0=1)(1=0) , gen(dst_hsg)
recode ckfl 	(0=1)(1=0) , gen(dst_ckfl)
recode asst_u 	(0=1)(1=0) , gen(dst_asst) 


recode cm   	(0=1)(1=0) , gen(dst_cm_01)				   		// hot dst est
recode nutr2_u	(0=1)(1=0) , gen(dst_nutr_01)
recode satt_u 	(0=1)(1=0) , gen(dst_satt_01)
recode educ_u 	(0=1)(1=0) , gen(dst_educ_01)
recode elct 	(0=1)(1=0) , gen(dst_elct_01)
recode wtr_u  	(0=1)(1=0) , gen(dst_wtr_01)
recode sani_u 	(0=1)(1=0) , gen(dst_sani_01)
recode hsg_u  	(0=1)(1=0) , gen(dst_hsg_01)
recode ckfl 	(0=1)(1=0) , gen(dst_ckfl_01)
recode asst_u 	(0=1)(1=0) , gen(dst_asst_01) 



lab def la_dp 1"yes" 0"no"
foreach var in d_* dst_* d_*_* dst_*_* {
lab val `var' la_dp
}

foreach var in cm nutr satt educ elct wtr sani hsg ckfl asst {
lab var d_`var' "deprived in `var'"
lab var d_`var'_01 "hot: deprived in `var'"
lab var dst_`var' "dst: deprived in `var'"
lab var dst_`var'_01 "hot-dst: deprived in `var'"
}


keep hh_id ind_id strata psu weight chswgt ///
sex age agec* area region* hship intvw_* ///
scheg_a att edueg eduyr chelg uw_st_a ///
d_* dst_* wtr_sdg ws4

	 
order hh_id ind_id strata psu weight chswgt ///
sex age agec* area region* hship intvw_* ///
scheg_a att edueg eduyr chelg uw_st_a ///
d_* dst_* wtr_sdg ws4 


mdesc psu strata area age hship region* d_* dst_*


char _dta[cty] "Cote d'Ivoire"
char _dta[ccty] "CIV"
char _dta[year] "2016" 	
char _dta[survey] "MICS"
char _dta[ccnum] "384"
char _dta[type] "micro"


sort ind_id
compress
la da "Micro data for `_dta[ccty]' (`_dta[ccnum]') from `c(current_date)' (`c(current_time)')."
save "$path_out/civ_mics16.dta", replace 
