clear;



alpha = [1.1,1.11,1.12,1.125,1.13,1.1301,1.1302,1.13025];
file = {'Schnack1/a1p1DT1','Schnack1/a1p11DT1','Schnack1/a1p12DT1',...
    'Schnack1/a1p125DT1','Schnack1/a1p13DT1','Schnack1/a1p1301DT1',...
    'Schnack1/a1p1302DT1','Schnack1/a1p13025DT1'};
GMnums = length(alpha);
period = ones(1,GMnums);
dt=1;
for i=1:GMnums
    M = load([char(string(file(i))),'.csv']);
    MaxHeight = max(M(round(end/3):end,2));
    [PKS,LOCS]= findpeaks(M(round(end/3):end,2),'MinPeakHeight',MaxHeight*2/3);
    period(i) =mean(diff(LOCS))*dt;
%     plot(M(round(end/3):end,2))
%     hold on
%     plot(LOCS,PKS,'*')
%     figure
end


c = 1/4;
alphastar = alpha(end)-(c)*(alpha(end-1)-alpha(end));
alphas = alphastar-alpha;

loglog(alphas,period,'-*','linewidth',2,'markersize',10);

xalpha = linspace(alpha(1),alpha(end),1000);
xalphas = linspace(alphas(1),alphas(end),1000);

pLaw = polyfit(log(alphas),log(period),1);
hold on;
loglog(xalphas,exp(pLaw(2))*xalphas.^pLaw(1),'linewidth',2); 

%pLog = polyfit(log(alphas),period,1);
%loglog(xalphas,pLog(1)*log(xalphas)+pLog(2),'linewidth',2);

xlabel('$|\alpha-\alpha^*|$','interpreter','latex');
ylabel('$P$','interpreter','latex');
h = legend('Simulations','$P \propto |\alpha-\alpha^*|^{-0.4385}$','location','northeast');
set(h,'interpreter','latex');
set(gca,'FontSize',12)
set(h,'FontSize',20)
%axis tight;



