clear;

%2.9, 2.85,
%'GM2/alpha2p9','GM2/alpha2p85',
alpha = [2.83,2.829,2.8284,2.82832,2.82831,2.828305,2.8283,2.828298,2.828297];
file = {'GM2/alpha2p83','GM2/alpha2p829','GM2/alpha2p8284','GM2/alpha2p82832','GM2/alpha2p82831','GM2/alpha2p828305','GM2/alpha2p8283','GM2/alpha2p828298','GM2/alpha2p828297'};
GMnums = length(alpha);
period = ones(1,GMnums);
dt=1;
for i=1:GMnums
    M = load([char(string(file(i))),'.csv']);
    MaxHeight = max(M(round(end/3):end,2));
    [PKS,LOCS]= findpeaks(M(round(end/3):end,2),'MinPeakHeight',MaxHeight*2/3);
    period(i) =mean(diff(LOCS))*dt;
%     plot(M(round(end/3):end,2))
%     hold on
%     plot(LOCS,PKS,'*')
%     figure
end

    
c = 1/4;
alphastar = alpha(end)-(c)*(alpha(end-1)-alpha(end));
alphas = alpha-alphastar;

loglog(alphas,period,'-*','linewidth',2,'markersize',10);

xalpha = linspace(alpha(1),alpha(end),1000);
xalphas = linspace(alphas(1),alphas(end),1000);

pLaw = polyfit(log(alphas),log(period),1);
hold on;
loglog(xalphas,exp(pLaw(2))*xalphas.^pLaw(1),'linewidth',2); 

%pLog = polyfit(log(alphas),period,1);
%plot(xalphas,pLog(1)*log(xalphas)+pLog(2),'linewidth',2);

xlabel('$|\alpha-\alpha^*|$','interpreter','latex');
ylabel('$P$','interpreter','latex');
h = legend('Simulations','$P \propto |\alpha-\alpha^*|^{-0.37}$','location','northeast');
set(h,'interpreter','latex');
set(gca,'FontSize',12)
set(h,'FontSize',20)
%axis tight;



