clear;


alpha = [0.36,0.35,0.349,0.3489,0.34889,0.34888,0.34887,0.3488675,0.348865,0.3488625, 0.3488615];
file = {'GM1/alpha0p36','GM1/alpha0p35','GM1/alpha0p349','GM1/alpha0p3489','GM1/alpha0p34889','GM1/alpha0p34888',...
    'GM1/alpha0p34887', 'GM1/alpha0p3488675','GM1/alpha0p348865','GM1/alpha0p3488625','GM1/alpha0p3488615'};
GMnums = length(alpha);
period = ones(1,GMnums);
dt=1;
for i=1:GMnums
    M = load([char(string(file(i))),'.csv']);
    MaxHeight = max(M(round(end/3):end,2));
    [PKS,LOCS]= findpeaks(M(round(end/3):end,2),'MinPeakHeight',MaxHeight*2/3);
    period(i) =mean(diff(LOCS))*dt;
%     plot(M(round(end/3):end,2))
%     hold on
%     plot(LOCS,PKS,'*')
%     figure
end

    
c = 1/4;
alphastar = alpha(end)-(c)*(alpha(end-1)-alpha(end));
alphas = alpha-alphastar;

loglog(alphas,period,'-*','linewidth',2,'markersize',10);

xalpha = linspace(alpha(1),alpha(end),1000);
xalphas = linspace(alphas(1),alphas(end),1000);

pLaw = polyfit(log(alphas),log(period),1);
hold on;
loglog(xalphas,exp(pLaw(2))*xalphas.^pLaw(1),'linewidth',2); 

%pLog = polyfit(log(alphas),period,1);
%plot(xalphas,pLog(1)*log(xalphas)+pLog(2),'linewidth',2);

xlabel('$|\alpha-\alpha^*|$','interpreter','latex');
ylabel('$P$','interpreter','latex');
h = legend('Simulations','$P \propto |\alpha-\alpha^*|^{-0.0945}$','location','northeast');
set(h,'interpreter','latex');
set(gca,'FontSize',12)
set(h,'FontSize',20)
%axis tight;



