import matplotlib.pyplot
import os

colours = {'ox blue'     :(0/255.0, 33/255.0, 71/255.0),
			'light blue': (158/255,206/255,235/255),
			'red'    :(135/255.0, 36/255.0, 52/255.0),
			'pink'  :(235/255.0, 196/255.0, 203/255.0),
			'green'  :(105/255.0, 145/255.0, 59/255.0),
			'palegreen'  :(206./255.0, 219/255.0, 175/255.0),
			'orange'  :(207/255.0, 122/255.0, 48./255.0),
			'yellow'  :(243/255.0, 222/255.0, 116/255.0),
			'gray'   :(167/255.0, 157/255.0, 150/255.0),
			'teal':(0/255,119/255,112/255)}

def plot_style(style=None):
	'''
	Simple function to change plot style to one of the pre defined ones.

	available styles are:
	 'single column',
	 'two column',
	 'half column',
	 'large two column'
	 'full page',
	  thesis',
	 'large thesis'

	The default is 'single column'.
	'''

	cwd = os.path.dirname(os.path.abspath(__file__))

	fpath = os.path.join(cwd,"StyleFiles","")
	stylefile='default.mplstyle'
	if style != None:
		style = style.lower()
		if style in ["two column","twocolumn","wide"]:
			stylefile = 'Wide.mplstyle'

		elif style in ["large two column","largetwocolumn","largewide",
						"large wide"]:
			stylefile = 'LargeWide.mplstyle'

		elif style in ["half column","halfcolumn","small"]:
			stylefile = 'small.mplstyle'

		elif style in ["full page","fullpage"]:
			stylefile = 'FullPage.mplstyle'

		elif style =="thesis":
			stylefile = 'Thesis.mplstyle'

		elif style in ["largethesis", "large thesis","large"]:
			stylefile = 'BigThesis.mplstyle'

		elif style in ["normal" or "single column" or "default"]:
			stylefile='default.mplstyle'

		else:
			print("available styles are 'single column', 'two column',"+\
				" 'half column', 'full page', 'thesis', 'large thesis'. The"+\
				" default is 'single column'. ")
	else:
		print("available styles are 'single column', 'two column',"+\
				" 'half column', 'full page', 'thesis', 'large thesis'. The"+\
				" default is 'single column'. ")
	matplotlib.pyplot.style.use(fpath+stylefile)
