function IterativePWM()

name = 'Fig4b-2umBead-Axial-Reslice-1X-processing';
Z = 26;

% Open and setup file for data writing
Results = 'Profile.txt';
ID = fopen(Results,'a+');
fprintf(ID,'Filename\tDepth\tFWHM\te2\n'); % File header

for z = 1:Z
    
    % Open image
    X = strcat(name,'.tif');
    Im = imread(X, 'index', z);
    
    % Measure width at both positions in micron
    PixelSize = 0.435;
    Display = 0;
    Scaling = 11 ;
    [Dia13,Dia50] = ProfileWidthMain(Im', PixelSize, Display, Scaling);
    
    % Print data to file
    fprintf(ID,'%s\t%10.1f\t%10.6f\t%10.6f\n',X, z, Dia50, Dia13);
end
fclose(ID);
