function [ImResize, LengthOfDim1, LengthOfDim2] = ImageResizer(Im, ScaleFactor  )
% This function resizes an image (Im) by a an amount equal to ScaleFactor
% with a bicubic algorithm in one dimension (columns).
%
% ScaleFactor: Factor by which you want to scale the original image
%
% By Raphael Turcotte (2012)
% Wellman Center for Photomedicine
% rturcotte861@gmail.com


% Resize the original image
[numrows, numcols] = size(Im);
ImResize = imresize(Im, [numrows ScaleFactor.*numcols], 'bilinear');

% New dimensions
DimImResize = size(ImResize);
LengthOfDim1 = DimImResize(1, 1);
LengthOfDim2 = DimImResize(1, 2);