function IterativeImageNormxcorr2()
%%
% Call ImageDifference over all suitable files in a user-selected folder
%%

% Promt user to select folder containing SIM sequences to analyze.
[~, Pathname] = uigetfile('*.tif', 'Pick a mat-file');

% Get file information
dirData = dir(Pathname);      %# Get the data for the current directory
dirIndex = [dirData.isdir];  %# Find the index for directories
fileList = {dirData(~dirIndex).name}';  %'# Get a list of the files
if ~isempty(fileList)
    fileList = cellfun(@(x) fullfile(Pathname,x),fileList,'UniformOutput',false);
else
    msgbox('No file in selected folder.','Invalid input','error');
    return
end

Results = 'Results.txt';
ID = fopen(Results,'a+');
fprintf(ID,'Filename\t12\t13\t23\n');
fclose(ID);

% Perform ISG4SIM over all suitable files in the selected folder
for i = 1:1:length(fileList)
    Filename = char(fileList(i));
    if ~isempty(strfind(Filename, 'tif'))
        ImageNormxcorr2(Filename);
    end
end

msgbox('Analysis Completed. All Output files are in the data folder.','Iterative ISG4SIM');
