function ImageNormxcorr2(seqFilename)

%%%
% Calculate the difference to a reference image as the translation 
% invariant normalized RMS error of every frame in a multi-frame file
% (seqFilename). The file should contain only 9 images, of which the last 
% one is the desired reference.
%%%

% Read and display image
[imageseries,nImages,~,~,~] = loadimageseries(seqFilename);

%%% ------------------------------------------------------------------- %%%

    C12 = max(max(normxcorr2(imageseries(:,:,1),imageseries(:,:,2))));
    C13 = max(max(normxcorr2(imageseries(:,:,1),imageseries(:,:,3))));
    C23 = max(max(normxcorr2(imageseries(:,:,2),imageseries(:,:,3))));

% Save Results to text file
Results = 'Results.txt';
ID = fopen(Results,'a+');
fprintf(ID,[seqFilename(end-20:end) '\t']);
fprintf(ID,'%10.4f\t%10.4f\t%10.4f\n', C12, C13, C23);
fclose(ID);