%% Load data
DataFileName = 'CW_IEF1.tif';
[imageseries,numberofimages,xsize,ysize] = loadimageseries(DataFileName);
Data = double(zeros(xsize,ysize,3));
Dark = 2;

%% Generate HDR

% Neutral density in place
FE = [0,1,16];

for i = 1:169
    % Call function for computing HDRs
    
    Data(:,:,1) = double(imageseries(:,:,i));
    Data(:,:,2) = double(imageseries(:,:,i+169));
    Data(:,:,3) = double(imageseries(:,:,i+2*169));
    
    HDRimage = HDR_RT(Data, Dark, FE);
    HDRimage = uint32(HDRimage);
    
    %% Save HDR
    
    HDRfilename = [DataFileName(1:end-4) '_' num2str(i) '_HDR.tif'];
    saveImage_uint32(HDRfilename, HDRimage);
end