function HDRimage = HDR_RT(ImageStack, Dark, FE)

%% Convert multiple exposures to a single high-dynamic-range (HDR) image

% Subtract background
for nd_iter = 1:length(FE)
    ImageStack(:,:,nd_iter) = ImageStack(:,:,nd_iter)-Dark; 
end

% Cut off values
MinCutOff = Dark; %100;
HighCutOff = 255-Dark; %3700;
ImageStack(ImageStack < MinCutOff | ImageStack > HighCutOff) = NaN;

% Compute corrected a.u. intensity as a function of ND
for nd_iter = 1:length(FE)
    ImageStack(:,:,nd_iter) = abs(FE(nd_iter))*ImageStack(:,:,nd_iter);  
end

% HDR: take the first non-nan maximum along the ND dimension.
HDRimage = nanmax(ImageStack,[],3);

