function check_dataupload(datadir)
% check_dataupload(datadir)
%
% datadir is directory of data
% e.g. check_dataupload('C:\FeSc2S4_powder\PublicAccessData')
%

if ~exist('datadir','var') || isempty(datadir)
    datadir=pwd;
end

% add a slash to the data directory if one isn't included
correctslash=backorforwardslash(datadir);
if ~strcmpi(datadir(end),correctslash)
    datadir=[datadir correctslash];
end

startfig=100;
colordef white
% Fig 2a
filename='fig_2a.dat';
n=209;m=590;ax=[0.18 1.85 -0.5 7];ilims=[0 500];
plotFeSc2S4data([datadir filename],n,m,ax,ilims,startfig);
startfig=startfig+1;
title(uscoreesc(filename));

% Fig 2b
filename='fig_2b.dat';
n=77;m=81;ax=[0.18 1.85 -0.5 7];ilims=[0 500];
plotFeSc2S4data([datadir filename],n,m,ax,ilims,startfig);
startfig=startfig+1;
title(uscoreesc(filename));

% Fig 2c
filename='fig_2c.xye';
data=dlmread([datadir filename]);
figure(startfig);
errorbar(data(:,1),data(:,2),data(:,3),'ko');
hold on
plot(data(:,4),data(:,5),'m-');
hold off
startfig=startfig+1;
title(uscoreesc(filename));

% Fig 3a
filename='fig_3a.dat';
n=41;m=451;ax=[0.35 0.85 0 2];ilims=[0 1];
plotFeSc2S4data([datadir filename],n,m,ax,ilims,startfig);
startfig=startfig+1;
title(uscoreesc(filename));

% Fig 3b
filename='fig_3b.dat';
n=41;m=451;ax=[0.35 0.85 0 2];ilims=[0 1];
plotFeSc2S4data([datadir filename],n,m,ax,ilims,startfig);
startfig=startfig+1;
title(uscoreesc(filename));

% Fig 3c
filename='fig_3c.dat';
n=41;m=451;ax=[0.35 0.85 0 2];ilims=[0 1];
plotFeSc2S4data([datadir filename],n,m,ax,ilims,startfig);
startfig=startfig+1;
title(uscoreesc(filename));

% Fig 3d
filename='fig_3d.dat';
n=41;m=251;ax=[0.35 0.85 0 2];ilims=[0 1];
plotFeSc2S4data([datadir filename],n,m,ax,ilims,startfig);
startfig=startfig+1;
title(uscoreesc(filename));

% Fig 3e
filename='fig_3e.dat';
n=41;m=251;ax=[0.35 0.85 0 2];ilims=[0 1];
plotFeSc2S4data([datadir filename],n,m,ax,ilims,startfig);
startfig=startfig+1;
title(uscoreesc(filename));

% Fig 3f
filename='fig_3f.dat';
n=41;m=251;ax=[0.35 0.85 0 2];ilims=[0 1];
plotFeSc2S4data([datadir filename],n,m,ax,ilims,startfig);
startfig=startfig+1;
title(uscoreesc(filename));

% Fig 4a
filename='fig_4a_0T_80K.xye';
data=dlmread([datadir filename]);
figure(startfig);
errorbar(data(:,1),data(:,2),data(:,3),'ro');
hold on
filename='fig_4a_0T.xye';
data=dlmread([datadir filename]);
errorbar(data(:,1),data(:,2),data(:,3),'mo');
plot(data(:,4),data(:,5),'m--');
filename='fig_4a_4T.xye';
data=dlmread([datadir filename]);
errorbar(data(:,1),data(:,2),data(:,3),'gv');
plot(data(:,4),data(:,5),'g--');
filename='fig_4a_8p5T.xye';
data=dlmread([datadir filename]);
errorbar(data(:,1),data(:,2),data(:,3),'bs');
plot(data(:,4),data(:,5),'b--');
hold off
startfig=startfig+1;
title('Fig 4a');

% Fig S3g
filename='fig_S3g.xye';
data=dlmread([datadir filename]);
figure(startfig);
errorbar(data(:,1),data(:,2),data(:,3),'ko');
startfig=startfig+1;
title(uscoreesc(filename));

% Fig S3e
filename='fig_S3e.dat';
n=211;m=590;ax=[0.15 2 -5 5];ilims=[0 500];
plotFeSc2S4data([datadir filename],n,m,ax,ilims,startfig);
startfig=startfig+1;
title(uscoreesc(filename));

% Fig S3e
filename='fig_S3e.dat';
n=211;m=590;ax=[0.15 2 -5 5];ilims=[0 500];
plotFeSc2S4data([datadir filename],n,m,ax,ilims,startfig);
startfig=startfig+1;
title(uscoreesc(filename));

% Fig S4a
filename='fig_S4a.xy';
data=dlmread([datadir filename]);
figure(startfig);
plot(data(:,1),data(:,2),'ko-');
startfig=startfig+1;
title(uscoreesc(filename));

% Fig S4b
filename='fig_S4b.xy';
data=dlmread([datadir filename]);
figure(startfig);
plot(data(:,1),data(:,2),'ko-');
startfig=startfig+1;
title(uscoreesc(filename));

% Fig S5
filename='fig_S5.xy';
data=dlmread([datadir filename]);
figure(startfig);
plot(data(:,1),data(:,2),'ko');
title(uscoreesc(filename));

return

%% Sub functions
function plotFeSc2S4data(filename,n,m,ax,ilims,fignum)

a=load(filename,'ascii');x=reshape(a(:,1),n,m);y=reshape(a(:,2),n,m);z=reshape(a(:,3),n,m);
xx=(x(1:(end-1),:)+x(2:end,:))/2;x1=x(1,:)-(-x(1,:)+xx(1,:));xn=x(end,:)+(x(end,:)-xx(end,:));xb=[x1;xx;xn];xb(:,end+1)=xb(:,end);
yy=(y(:,1:(end-1))+y(:,2:end))/2;y1=y(:,1)-(-y(:,1)+yy(:,1));yn=y(:,end)+(y(:,end)-yy(:,end));yb=[y1 yy yn];yb(end+1,:)=yb(end,:);
z(end+1,:)=NaN;z(:,end+1)=NaN;
figure(fignum);pcolor(xb,yb,z);load coltab.dat -ascii; shading flat; axis(ax);colormap(coltab);caxis(ilims);

return

function correctslash=backorforwardslash(inputdirectory)
    nbck=numel(strfind(inputdirectory,'\'));
    nfwd=numel(strfind(inputdirectory,'/'));
    if nfwd>nbck
        correctslash='/';
    else
        correctslash='\';
    end
return

function outstring=uscoreesc(instring)
outstring=instring;
ulocs=strfind(instring,'_');
if ~isempty(ulocs)
    for l=1:numel(ulocs)
        outstring=[outstring(1:ulocs(l)-1) '\' outstring(ulocs(l):end)];
    end
end
return