#!/bin/sh

# usage: deface_anat bids-dir bids-sub
# defacing based on https://github.com/hanke/gumpdata/blob/master/scripts/conversion/convert_dicoms_anatomy

# sub-sample anatomical image
fslmaths $1/$2/anat/$2_T1w -subsamp2 $1/$2/anat/$2_temp_subsamp

# register template to subsampled anatomical image
flirt -in $1/code/deface_templates/tmpl_shifted \
	-inweight $1/code/deface_templates/head_tmpl_weights.nii \
	-ref $1/$2/anat/$2_temp_subsamp -omat $1/$2/anat/$2_temp_xfm.mat \
	-out $1/$2/anat/$2_temp_xfm -bins 256 -cost corratio -dof 12 -v

# apply transform to move face/teeth/ear mask (ftem) into anatomical space
flirt -in $1/code/deface_templates/face_teeth_ear_mask.nii \
	-init $1/$2/anat/$2_temp_xfm.mat -applyxfm -out $1/$2/anat/$2_temp_ftem \
	-interp trilinear -ref $1/$2/anat/$2_T1w -v

# copy anatomical with face
if [ ! -d "$1/faced_anat" ]; then
	mkdir $1/faced_anat
fi
fslmaths $1/$2/anat/$2_T1w $1/faced_anat/$2_T1w

# create deface mask
fslmaths $1/$2/anat/$2_temp_ftem -thr 0.5 -bin $1/$2/anat/$2_defacemask

# apply deface mask to anatomical
fslmaths $1/$2/anat/$2_T1w -mas $1/$2/anat/$2_defacemask $1/$2/anat/$2_T1w

# tidy up temporary files
rm $1/$2/anat/*_temp_*

