% MATLAB script to rename files with specific naming pattern

% Specify the folder containing the files
folderPath = pwd;

% Get a list of all files in the folder
files = dir(fullfile(folderPath, 'angleSweeps_*.dat'));

% Loop through each file
for i = 1:length(files)
    % Get the current file name
    oldName = files(i).name;
    
    % Find the position of the file extension
    [~, name, ext] = fileparts(oldName); % name is the file name without extension, ext is '.dat'
    
    % Replace spaces with underscores in the name
    newName = strrep(name, ' ', '_');
    
    % Replace decimal points with 'p' in the name
    newName = strrep(newName, '.', 'p');
    
    % Reconstruct the full new name with the original extension
    newFullName = [newName, ext];
    
    % Rename the file
    movefile(fullfile(folderPath, oldName), fullfile(folderPath, newFullName));
end

disp('File renaming completed.');

