fpath = 'C:\Users\kasim\Desktop\Simulation\jimmy-exp\16-exp-2-18-a-1.5\h5-e2\';
datasetname = '/e2';

fpath1 = 'C:\Users\kasim\Desktop\Simulation\jimmy-exp\16-exp-2-18-a-1.5\h5-electrons\';
datasetname1 = '/charge';

fpathFig = 'C:\Users\kasim\Desktop\Simulation\jimmy-exp\16-exp-2-18-a-1.5\s2-revision\';

% universal constant
c = 3E8;
e = 1.6E-19;
e0 = 8.85E-12;
m = 9.1E-31;

% physical parameters
xtot = 110;
xprobe = 97;
xplasma = 110;
Ntot = 44000;
Ndownsample = 5;

N = round(xprobe/xtot*Ntot/Ndownsample); %7760; % sampling points
Nfiles = 187; % number of files
lambdal = 800E-9;
n = 2E18*1E6;
wp = (n * e * e / m / e0)^.5;
w0 = 2*pi*c / lambdal;
up = (1-wp*wp/w0/w0)^.5*c;
dx = xtot/N * c/wp;
E0 = m*wp*c/e/1E9;
timeLag0 = 110*c/wp/up;
timeLag1 = 13*c/wp/up;

% boundary of the wigner
fmin = 0.02; % to get index 1: 1/2/N % was: 0.02
fmax = 0.1; % was: 0.1
ptXMin = round(N/2)-1030;
ptXMax = round(N/2)+1030;

% create the filter for integrator
nfir = 8000; % order of FIR
Nperiod = 515; % period of a wave (in downsampled sample)
f = linspace(0, 1, N);
f0 = 1/Nperiod * 2;
fbound = f0*3/4;
% fbound = f0;
a = (f > fbound) .* (f0*f0./f./f) + (f <= fbound) .* (f0*f0/fbound/fbound);
a(1) = f0*f0/fbound/fbound;
% a = a * (-1i);
d = fdesign.arbmag('N,F,A', nfir, f, a);
hd1 = design(d, 'equiripple');
dly1 = mean(grpdelay(hd1));

b = (f > fbound) .* (f0./f) + (f <= fbound) .* (f0/fbound);
b(1) = f0/fbound;
di = fdesign.arbmag('N,F,A', nfir, f, b);
hdi = design(di, 'equiripple');
dlyi = mean(grpdelay(hdi));

df = fdesign.differentiator('N,Fp,Fst', nfir, 6*f0, 6.5*f0);
hdf = design(df, 'equiripple');
dlyf = mean(grpdelay(hdf));
dphi = 2*pi / Nperiod;

lpfilter = fdesign.lowpass('N,Fc', nfir, 6*f0);
lpf = design(lpfilter,'window','window',@hamming);
dlylpf = mean(grpdelay(lpf));

% start scripting here
Ninterval = 1;
E1Tot = zeros(N, 1);
maxE1 = zeros(1, Nfiles/Ninterval);
maxE2 = zeros(1, Nfiles/Ninterval);
minE1 = zeros(1, Nfiles/Ninterval);
minE2 = zeros(1, Nfiles/Ninterval);
errors = zeros(1, Nfiles/Ninterval);

times = zeros(1, Nfiles/Ninterval);
iWindow = zeros(1, N);

for i = [1:Nfiles/Ninterval]*Ninterval
    % i=50;
    % read the e2 file
    fname = sprintf('e2-%06d.h5', i);
    filename = strcat(fpath, fname);
    data = h5read(filename, datasetname);
    data = data(1:N*Ndownsample);
    sampledData = downsample(data, Ndownsample);
    
    time = h5readatt(filename, '/', 'TIME') / wp;
    times(i) = time;
    % if (time == 0) time = 1/wp; end
    % create the time window (to show how long the part is travelling INSIDE the plasma)
    timeWindow = linspace(time-timeLag0, time-timeLag1, N);
    timeWindow = (timeWindow > 0) .* timeWindow + (timeWindow <= 0) .* 1/wp;
    
    % update the i-window
    xminFile = h5readatt(filename, '/', 'XMIN');
    xmaxFile = h5readatt(filename, '/', 'XMAX');
    xminFile = xminFile(1);
    xmaxFile = xmaxFile(1);
    xcoords = linspace(xminFile, xmaxFile, Ntot/Ndownsample);
    xcoords = xcoords(1:N);
    iWindow = iWindow + (xcoords > xplasma);
    iiWindow = (iWindow > 0) .* iWindow + (iWindow <= 0) .* iWindow;
    
    wigner = tfrwv(sampledData);
    frequency = ([1:N])'/N*.5;
    frequency = repmat(frequency, 1, N);
    
    % boundary of wigner distribution
    i1 = round(fmin/0.5*N);
    i2 = round(fmax/0.5*N);
    wignerSignal = wigner(i1:i2, 1:N);
    freqSignal = frequency(i1:i2, 1:N);
    
    % get the intensity
    h = figure;
    s2 = sum(wignerSignal, 1);
    x = ([1:N]/N-0.5) * xprobe * c/wp * 1E3;
    plot(x, s2/1E3, 'k-', 'LineWidth', 2);
    xlabel('z-ct (mm)', 'FontSize', 20);
    ylabel('Intensity (arbitrary unit)', 'FontSize', 20);
    ylim([-2 25]);
    set(gca, 'FontSize', 20);
    fnameFig = sprintf('intensity-%06d.png', i);
    filenameFig = strcat(fpathFig, fnameFig);
    saveas(h, filenameFig, 'png');
    close(h);
    
    maxS2 = max(s2);
    
    % get the frequency times intensity
    ws2 = sum(wignerSignal .* freqSignal, 1);
    
    % window the frequency only for places which intensity > 0.5% max intensity
    window = (s2 > 0.005*maxS2);
    windowIdx = find(window == 1);
    startIdx  = min(windowIdx(:));
    finishIdx = max(windowIdx(:));
    window = (s2 > 0.005*max(s2));
    
    % working in area where omega is still readable
    w2 = (ws2 ./ s2);% .* (s2 > 0.005*maxS2);
    % w2 = w2(startIdx:finishIdx);
    if (i == Ninterval) winit = w2(round(max(size(w2))/2)); end
    % plot(w2, 'b.');

    wAve = mean(w2);
    dww0 = (w2 - wAve)/wAve;
    % plot(dww0);

    dnn0dt = 2*w0*w0/wp/wp * dww0./timeWindow;
    dnn0dphase1 = -dnn0dt / wp;
    
    dnn0dphase = -(w2.^2-winit.^2)/wp.^2/wp * (w0.^2/winit.^2) ./ timeWindow;
    % plot(dnn0dphase);
    
    % dnn0dphaseComplete = [zeros(1, startIdx-1) dnn0dphase zeros(1, N-finishIdx)];
    dnn0dphaseComplete = dnn0dphase .* window;
    E2 = filter(hd1, [dnn0dphaseComplete, zeros(1, dly1)]);
    E2 = E2(dly1+1:end);
    E2 = filter(hdf, [E2, zeros(1, dlyf)]);
    E2 = E2(dlyf+1:end) ./ dphi - 1;
    
    % E2 = filter(hdi, [dnn0dphaseComplete, zeros(1, dlyi)]);
    % E2 = E2(dlyi+1:end) - 1;
    % mE2(i) = max(dnn0dphaseComplete(ptXMin:ptXMax));
    E2meas = E2(ptXMin:ptXMax);
    maxE2(i) = max(E2(ptXMin:ptXMax));
    minE2(i) = min(E2(ptXMin:ptXMax));
    
    % read the n file
    fname1 = sprintf('charge-electrons-%06d.h5', i);
    filename1 = strcat(fpath1, fname1);
    data1 = h5read(filename1, datasetname1);
    data1 = data1(1:N*Ndownsample);
    E1 = downsample(data1, Ndownsample);
    % E1 = filter(lpf, [E1;zeros(dlylpf,1)]);
    % E1 = E1(dlylpf+1:end);
    E1Tot = E1Tot + E1 * Ninterval;
    E1Ave = (E1Tot ./ iiWindow');
    % E1Ave = E1;
    E1meas = E1Ave(ptXMin:ptXMax);
    maxE1(i) = max(E1Ave(ptXMin:ptXMax));
    minE1(i) = min(E1Ave(ptXMin:ptXMax));
    sqError = (sum((E1meas' - E2meas) .^ 2) / (ptXMax-ptXMin+1))^.5;
    rmsValue = rms(E1meas-1);
    errors(i) = sqError/(maxE1(i) - minE1(i));
    
    % % save graphics file
    % h = figure;
    % x = ([1:N]/N-0.5) * xprobe * c/wp * 1E3;
    % plot(x, -E1Ave, 'b-', 'LineWidth', 2); hold on;
    % plot(x, -E2, 'r-', 'LineWidth', 2);
    % xlabel('z-ct (mm)', 'FontSize', 20);
    % ylabel('n/n_0', 'FontSize', 20);
    % set(gca, 'FontSize', 20);
    % ylim([0.45 2]);
    % % plot(x, dnn0dphaseComplete, 'b-', x, E1Ave, 'r-');
    % fnameFig = sprintf('fig-%06d.png', i);
    % filenameFig = strcat(fpathFig, fnameFig);
    % saveas(h, filenameFig, 'png');
    % close(h);

end

Nbound = round(Nfiles);
x = times((1:Nbound/Ninterval)*Ninterval)*c*1E3;
y1 = maxE1((1:Nbound/Ninterval)*Ninterval);
y2 = maxE2((1:Nbound/Ninterval)*Ninterval);
z1 = minE1((1:Nbound/Ninterval)*Ninterval);
z2 = minE2((1:Nbound/Ninterval)*Ninterval);

plot(x, (y1-z1), 'k-', 'LineWidth', 2); hold on;
plot(x, (y2-z2), 'k--', 'LineWidth', 2);
axis([0 7.5 0 1]);
% legend('Actual', 'Measurement', 'Location', 'NorthWest');
xlabel('Propagation distance (mm)');
ylabel('dn/n0');
% ylabel('

h = figure;
plot(x, abs((y1-z1)-(y2-z2))./(y1-z1)*100, 'k-', 'LineWidth', 2); hold on;
plot(x, x./x*10, 'k--', 'LineWidth', 1);
xlabel('Propagation distance (mm)');
ylabel('Relative error');
axis([0 7.5 0 100]);

h = figure;
plot(x, errors*100, 'k-', 'LineWidth', 2); hold on;
plot(x, x./x*10, 'k--', 'LineWidth', 1);
xlabel('Propagation distance (mm)');
ylabel('Relative error (percentage)');
axis([0 7.5 0 30]);
