import sys, os, base, readers, shutil, math
import numpy as np 


def set_com_to_zero(s):
    for strand in s._strands:
        diff = np.rint (strand.cm_pos / s._box ) * s._box
        for n in strand._nucleotides:
            n.cm_pos_box=n.cm_pos-diff
        #s.translate (-diff)
    '''cdm = np.array([0.,0.,0.])
    for strand in s._strands:
        for n in strand._nucleotides:
            cdm += n.cm_pos
    cdm = cdm / float (s.get_N_Nucleotides())'''
    
def bring_in_box(s):
    for strand in s._strands:
        strand.bring_in_box_nucleotides(s._box)


if len(sys.argv) < 2:
    print "Usage is %s trajectory, topology" % sys.argv[0]
    sys.exit()
l=readers.LorenzoReader(sys.argv[1], sys.argv[2])
s=l.get_system()
overall_a1=[]
overall_a3=[]
overall_pos=[]
a1_processing=[]
a3_processing=[]
pos_processing=[]
i=0
j=0
k=0
m=0
while s:
    temp_a1=[]
    temp_a3=[]
    temp_pos=[]

    set_com_to_zero(s)
    
    for n in s._nucleotides:
        pos=n.cm_pos_box
        #pos=[i, 0, 0]
        a1=n._a1
        a3=n._a3
        temp_pos.append(np.array([pos[0], pos[1], pos[2]]))
        temp_a1.append(np.array([a1[0], a1[1], a1[2]]))
        temp_a3.append(np.array([a3[0], a3[1], a3[2]]))
    if pos_processing==[]:
        pos_processing=(temp_pos)
        a1_processing=(temp_a1)
        a3_processing=(temp_a3)
    else:
        i=0
        while i<len(pos_processing):
            pos_processing[i]+=temp_pos[i]
            a1_processing[i]+=temp_a1[i]
            a3_processing[i]+=temp_a3[i]
            i+=1
    s=l.get_system()
    m+=1
for line in pos_processing:
    overall_pos.append(line/float(m))
for line in a1_processing:
    overall_a1.append(line/float(m))
for line in a3_processing:
    overall_a3.append(line/float(m))

'''while i<len(pos_processing[0]):
    j=0
    xyz=[0,0,0]
    while j<m:
        xyz+=pos_processing[j][i]
        j+=1
    overall_pos.append(xyz/m)
    i+=1

i=0
while i<len(a1_processing[0]):
    j=0
    xyz=[0,0,0]
    while j<m:
        xyz+=a1_processing[j][i]
        j+=1
    overall_a1.append(xyz/m)
    i+=1

i=0
while i<len(a3_processing[0]):
    j=0
    xyz=[0,0,0]
    while j<m:
        xyz+=a3_processing[j][i]
        j+=1
    overall_a3.append(xyz/m)
    i+=1'''

box_size=300

configuration_file=open("average.conf", "w")
configuration_file.close()

with open ("average.conf", "a+") as conf:
    conf.write("t = 0 \nb = %s %s %s \nE = 0 0 0 \n" %(box_size, box_size, box_size))

    for pos, a1, a3 in zip(overall_pos, overall_a1, overall_a3):
        new_pos="%s %s %s" %(pos[0], pos[1], pos[2])
        new_a1="%s %s %s" %(a1[0], a1[1], a1[2])
        new_a3="%s %s %s" %(a3[0], a3[1], a3[2])
        string="%s %s %s 0 0 0 0 0 0" %(new_pos, new_a1, new_a3)
        conf.write("%s \n" %string)
    
        
        
    


        
