#!/usr/bin/env python

"""
Take a phi-theta junction angle series (from hj_measure.py and e.g. with the wrong isomers removed) and convert it to a 2d histogram. This should produce an identical output to ~/CUDADNA/UTILS/hj_measure.py.
"""

import sys
import math

phi_ser = []
theta_ser = []
ff = open(sys.argv[1])
for line in ff.readlines():
    words = line.rstrip().split()
    phi_ser.append(float(words[1]))
    theta_ser.append(float(words[2]))
ff.close()

nbins1 = 360
nbins2 = 180
max1 = 360. # for phi
min1 = 0.
max2 = 90. # for theta
min2 = -90.

try:
    dx1 = (max1-min1)/float(nbins1)
    dx2 = (max2-min2)/float(nbins2)
    dy = 1./len(phi_ser)

    hist = [[0 for x in range(nbins1)] for y in range(nbins2)]

    for ii in range(len(phi_ser)):
        try:
            theta_bin = int(math.floor((theta_ser[ii]-min2)/dx2))
            phi_bin = int(math.floor((phi_ser[ii]-min1)/dx1))
            if phi_bin < 0 or theta_bin < 0:
                raise IndexError
            hist[theta_bin][phi_bin] += dy
        except IndexError:
            print >> sys.stderr, "out of range %f %f, dying" %(theta_ser[ii], phi_ser[ii])
            sys.exit(1)

    for ii in range(len(hist)):
        for jj in range(len(hist[ii])):
            print "%f %f %f" % ((ii+0.5)*dx2 + min2, (jj+0.5)*dx1 + min1, hist[ii][jj])

except:
    print 'Problem with your data in theta_phi_series2bin.py (probably array of len 1).'
    pass
