#!/usr/bin/env python

import sys
import matplotlib.pyplot as plt
import numpy as np
import pylab
from matplotlib import rcParams, rc
from scipy import ma
import parse_pt_fe as ppf

def plot_window():
	plt.rc('font', **{'family':'serif', 'serif':['Computer Modern Roman'],
                  'monospace':['Computer Modern Typewriter']})
	fig_width_pt = 246.0  # Get this from LaTeX using \showthe\columnwidth
	inches_per_pt = 1.0/72.27               # Convert pt to inch
	golden_mean = (np.sqrt(5)-1.0)/2.0         # Aesthetic ratio
	fig_width = fig_width_pt*inches_per_pt  # width in inches
	fig_height = fig_width*golden_mean      # height in inches
	fig_size =  [fig_width,fig_height]
	params = {'backend': 'ps',
	          'axes.labelsize': 10,
	          'text.fontsize': 10,
	          'legend.fontsize': 10,
	          'xtick.labelsize': 8,
	          'ytick.labelsize': 8,
	          'xtick.major.size' : 2.5,
			  'xtick.major.width' : 0.5,
			  'ytick.major.size' : 2.5,
              'ytick.major.width' : 0.5,
	          'text.usetex': True,
	          #'figure.figsize': fig_size,
	          'text.latex.preamble': [r"\usepackage{amstext}", r"\usepackage{mathpazo}"]}
	fig = pylab.figure(0, figsize = fig_size, facecolor='w', edgecolor='k')
	rcParams.update(params)
	return fig

def load_file_old(input): 
	w = np.loadtxt(input)

        heatmap = np.ones((9, 46), dtype = float) # (y, x)
        heatmap *= 10000.
        thetas = []
        phis = []
 	values = []
	for k, line in enumerate(w):
            theta, phi, c = float(line[0]), float(line[1]), float(line[2])
            if c != float("inf") and theta >= -17.5:
		thetas.append(theta)
		phis.append(phi)
                values.append(c)
		print theta,phi,c
                heatmap[int((theta+17.5)/5)][int((phi-12.5)/5)] = c
        thetas = sorted(list(set(thetas)))
        phis = sorted(list(set(phis)))

        heatmap = ma.masked_values(heatmap, 10000.)
	return heatmap, min(values), max(values), phis, thetas

sss1, miny, maxy, xvals, yvals = ppf.load_file(sys.argv[1])
save = False
if len(sys.argv) > 2 and sys.argv[2] == "-save":
	assert sys.argv[1] == "phi_theta_fe.dat", "This rather inflexible script will only save when a certain file is given to it. Easily changed if you want."
	save = True

fig = plot_window() 
ax1 = fig.add_subplot(111)

im = pylab.imshow( sss1, interpolation='nearest', aspect="auto", origin = 'center', vmin=miny, vmax=maxy, cmap='hot' )
# need to set the right ticks here
#ax1.set_xlim([-0.5,72.0-0.5])
#ax1.set_ylim([-0.5,36.0-0.5])
#ax1.set_ylim([-0.5,10.0-0.5])

# make the colourbar
cax = fig.add_axes([0.65, 0.75, 0.2, 0.05])
cbar = fig.colorbar(im, cax=cax, orientation='horizontal')#, shrink=0.5, aspect=20, fraction=.12,pad=.02)
cbar.set_label(r"$\Delta G ~/~ k_{\text{B}} T$", fontsize=9)
cbar.set_clim(miny, maxy)

ax1.set_xlabel(r'$\phi$', fontsize=9 )
ax1.set_xticks(range(6,46,9))
ax1.set_xticklabels(np.arange(42.5,223,45),fontsize=8) 
ax1.set_ylabel(r'$\theta$', fontsize=9 )
ax1.set_yticks(range(0,9,2))
ax1.set_yticklabels(np.arange(min(yvals),max(yvals)+10,10),fontsize=8) 

if save:
	plt.savefig("phi_theta_fe.pdf", bbox_inches = "tight", transparent = True)
else:
	plt.show()

