#!/usr/bin/env python

import sys
import matplotlib.pyplot as plt
import numpy as np
import pylab
from matplotlib import rcParams, rc
from scipy import ma
from matplotlib.ticker import NullFormatter
import parse_pt_fe as ppf

def plot_window():
	plt.rc('font', **{'family':'serif', 'serif':['Computer Modern Roman'],
                  'monospace':['Computer Modern Typewriter']})
	fig_width_pt = 246.0  # Get this from LaTeX using \showthe\columnwidth
	inches_per_pt = 1.0/72.27               # Convert pt to inch
	golden_mean = (np.sqrt(5)-1.0)/2.0         # Aesthetic ratio
	fig_width = fig_width_pt*inches_per_pt  # width in inches
	fig_height = fig_width*golden_mean      # height in inches
	fig_size =  [fig_width,fig_height]
	params = {'backend': 'ps',
	          'axes.labelsize': 18,
	          'text.fontsize': 18,
	          'legend.fontsize': 16,
	          'xtick.labelsize': 16,
	          'ytick.labelsize': 16,
	          'xtick.major.size' : 3.0,
		  'xtick.major.width' : 0.0,
		  'ytick.major.size' : 3.0,
                  'ytick.major.width' : 0.0,
	          'text.usetex': True,
	          #'figure.figsize': fig_size,
	          'text.latex.preamble': [r"\usepackage{amstext}", r"\usepackage{mathpazo}"]}
	fig = plt.figure(1, figsize = (7,7), facecolor='w', edgecolor='k')
	rcParams.update(params)
	return fig


def load_2d_file(input):
    w = np.loadtxt(input)
    heatmap = np.ones((360, 360), dtype = float) # (y, x)
    heatmap *= 10000.
    thetas = []
    phis = []
    values = []
    for k, line in enumerate(w):
        theta, phi, c = float(line[0]), float(line[1]), float(line[2])
        if c != float("inf"):
            thetas.append(theta)
            phis.append(phi)
            values.append(c)
            heatmap[theta,phi] = c
        print theta, phi 
        thetas = sorted(list(set(thetas)))
        phis = sorted(list(set(phis)))

        # Place the ticks and specify the labels
        # This is a bit of a nightmare, and I didn't make it very
        # flexible, sorry.
        # When changing the ticks in future, you may find the file
        # test_ticks.dat useful. should draw lines in the theta = 0.5, 
        # phi = 180.5 bins
        

        heatmap = ma.masked_values(heatmap, 10000.)

    return heatmap, min(values), max(values), phis, thetas#, phi_ticks, theta_ticks, phi_ticklabels, theta_ticklabels

save = True
if len(sys.argv) > 1 and sys.argv[1] == "-save":
	save = True

# plotting histograms alongside a 2d histogram: from http://matplotlib.org/examples/pylab_examples/scatter_hist.html
# definitions for the axes
left, width = 0.1, 0.65
bottom, height = 0.1, 0.65
left_h = left + width + 0.02
bottom_h = bottom + height + 0.02

rect_2d = [left, bottom, width, height]
rect_histx = [left, bottom_h, width, 0.2]
rect_histy = [left_h, bottom, 0.2, height]

# start with a rectangular Figure
fig = plot_window()#1, figsize=(12,8))

ax2d = plt.axes(rect_2d)


sss1, miny, maxy, xvals, yvals = load_2d_file("phi_theta_fe.dat")

maxy = 8.0
im = pylab.imshow( sss1, extent=[25,240,7.5,32.5], interpolation='nearest', aspect="auto", origin = 'center', vmin=miny, vmax=maxy, cmap='gist_ncar' )#spectral
#extent=[25,240,-17.5,10.5]

for line in sss1:
	print line 

sys.exit()
print len(xvals), min(xvals), max(xvals), len(yvals), min(yvals), max(yvals)

axHistx = plt.axes(rect_histx)
axHisty = plt.axes(rect_histy)

# no labels
axHistx.xaxis.set_major_formatter(NullFormatter())
axHisty.yaxis.set_major_formatter(NullFormatter())

# make the colourbar
cb_pad = 0.03
cb_left = 0.1 + cb_pad
cb_bottom = 0.65
cb_width = 0.3
cb_height = bottom + height - cb_bottom - cb_pad
cax = fig.add_axes([cb_left, cb_bottom, cb_width, cb_height])
cbar = fig.colorbar(im, cax=cax, orientation='horizontal', ticks=[0,2,4,6,8])#, shrink=0.5, aspect=20, fraction=.12,pad=.02)
cbar.set_label(r"$\Delta G / (k_{\rm B}T)$")
cbar.set_clim(miny, maxy)

# main plot ticks
ax2d.set_xlabel(r'$\phi$')
#ax2d.set_xticks(xticks)
#ax2d.set_xticklabels(xticklabels)
ax2d.set_ylabel(r'$\theta$')
#ax2d.set_yticks(yticks)
#ax2d.set_yticklabels(yticklabels)

plt.tick_params(axis='x', which='both', bottom='on', top='on', direction='in', width = 1.0)
plt.tick_params(axis='y', which='both', left='on', right='on', direction='in', width = 1.0)

ax2d.get_yaxis().set_tick_params(which = 'both', direction = 'in', bottom='on', top='on', width = 1.0)
ax2d.get_xaxis().set_tick_params(which = 'both', direction = 'in', bottom='on', top='on', width = 1.0)

# x-histogram
xdat = ppf.load_phi_hist("phi_fe.dat")
axHistx.plot(xdat[0], xdat[1])
axHistx.set_xticks(range(0,360,45))
axHistx.set_ylim([0, 10])
axHistx.set_ylabel(r"$\Delta G / (k_{\rm B}T)$")
axHistx.set_xlim([min(xvals)-0.5, max(xvals)+1.5])

axHistx.get_yaxis().set_tick_params(which = 'both', direction = 'in', bottom='on', top='on', width = 1.0)
axHistx.get_xaxis().set_tick_params(which = 'both', direction = 'in', bottom='on', top='on', width = 1.0)

# y-histogram
ydat_all = ppf.load_theta_hist("theta_fe.dat")
ydat_subset = ppf.load_theta_hist("theta_fe_subset.dat")

axHisty.plot(ydat_all[1], ydat_all[0])
axHisty.plot(ydat_subset[1], ydat_subset[0], linestyle = "dashed")

axHisty.set_xticks([0,5,10])
axHisty.set_yticks(range(-180,180,5))
axHisty.set_xlim([0,12])
axHisty.set_ylim([min(yvals)-0.5, 30.0+1])
axHisty.set_xlabel(r"$\Delta G / (k_{\rm B}T)$")

axHisty.get_yaxis().set_tick_params(which = 'both', direction = 'in', bottom='on', top='on', width = 1.0)
axHisty.get_xaxis().set_tick_params(which = 'both', direction = 'in', bottom='on', top='on', width = 1.0)

# shaded region from phi = 160 to phi = 180
ax2d.axvspan(160-6.5, 180-6.5, facecolor = "gray", edgecolor = "none", alpha = 0.3)

if save:
	plt.savefig("phi_theta_fe.pdf", bbox_inches = "tight", transparent = True)
else:
	plt.show()
