#!/bin/bash

# Use the WHAM script to paste together the phi windows and make a complete 
# free-energy landscape
#
# We use the "unnorm" histograms, which are not normalised but rather weighted 
# by sampling. In the "unnorm" histograms, the number in each bin corresponds 
# to the actual number of configurations placed in that bin. NB that the numbers
# are not exactly integers because of precision errors when the initially 
# *normalised* histograms were written. This is an unnecessarily complicated 
# way to do things but I don't think it's worth fixing now.

set -e
set -u

#./make_window_weights.py 80 160 > 120/window.dat
./make_window_weights.py 100 180 > 140/window.dat
./make_window_weights.py 120 200 > 160/window.dat
./make_window_weights.py 140 220 > 180/window.dat
./make_window_weights.py 160 240 > 200/window.dat
./make_window_weights.py 0 360 > unbiased/window.dat

./wham.py 2 140/window.dat 140/phi_theta_hist_unnorm.dat 160/window.dat 160/phi_theta_hist_unnorm.dat 180/window.dat 180/phi_theta_hist_unnorm.dat 200/window.dat 200/phi_theta_hist_unnorm.dat unbiased/window.dat unbiased/phi_theta_hist_unnorm.dat > wham_hist.dat

#./wham.py 2 140/window.dat 140/phi_theta_hist_unnorm.dat 160/window.dat 160/phi_theta_hist_unnorm.dat 180/window.dat 180/phi_theta_hist_unnorm.dat 200/window.dat 200/phi_theta_hist_unnorm.dat unbiased/window.dat unbiased/phi_theta_hist_unnorm.dat > wham_hist.dat 
./gen_fe_files.py


echo "Plotting ..."
python plot_heatmap_hist.py True
