#!/usr/bin/env python

"""
Take the 2d histogram produced by wham.py and make a 2d free energy landscape and 1d profiles in theta and phi
"""

import numpy as np

def default_add(dict, key, val):
    if key in dict.keys():
        dict[key] += val
    else:
        dict[key] = val
    return dict

def write_profile(fname, mydict, shift=0):
    profilef = open(fname, "w")
    normalisation = max(mydict.values())
    for key, val in sorted(mydict.items(), key = lambda x: x[0]):
        profilef.write("%f %f\n" % (key, -np.log(float(val)/normalisation) + shift))
    profilef.close()

hist2df = open("wham_hist.dat")
landscapef = open("phi_theta_fe.dat", "w")
lines = []
thetas = []
phis = []
populations = []
for line in hist2df.readlines():
    words = line.rstrip().split()
    phi = float(words[1])
    # discard very poorly sampled data above phi = 240
    if phi < 240:
        populations.append(float(words[2]))
        lines.append(words)
        thetas.append(float(words[0]))
        phis.append(float(words[1]))

hist2df.close()

# normalise the populations so that the largest has value 1, and the smallest free energy has value 0
normalisation = max(populations)
for ii, pop in enumerate(populations):
    landscapef.write("%s %s %f\n" % (thetas[ii], phis[ii], -np.log(float(float(pop)/normalisation))))

landscapef.close()

thetas = sorted(list(set(thetas)))
phis = sorted(list(set(phis)))
phi_hist = {}
theta_hist = {}
theta_hist_subset = {}
for words in lines:
    theta = float(words[0])
    phi = float(words[1])
    val = float(words[2])
    phi_hist = default_add(phi_hist, phi, val)
    theta_hist = default_add(theta_hist, theta, val)
    if 160 < phi < 180:
        theta_hist_subset = default_add(theta_hist_subset, theta, val)

write_profile("phi_fe.dat", phi_hist)
write_profile("theta_fe.dat", theta_hist)
write_profile("theta_fe_subset.dat", theta_hist_subset)
