""" Parameters for the analytical molecular beam model,
"""

class NH3HeBeam(object):
    """ Parameters for multi-component molecular beam.

    Parameters:
      m (float, list) : List of species masses in u.
      cp (float, list) : Species heat capacity (J/mol/K)
      molfrac (float, list) : Mole fraction of each species.
      d (float) : Nozzle diameter (mm).
      p0 (float) : Source pressure (bar).
      t0 (float) : Source temperature (bar).
      sigma (float) : Hard-sphere collision cross section in m^2
    """
    m       = (4.0026,  17.0305) 
    cp      = (20.7855, 36.8662)
    molfrac = (0.99,     0.01)
    d = 0.5
    p0 = 5
    t0 = 298
    sigma = 2.1e-21

